/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInfo;
import java.io.IOException;

public class SqlMigrationTaskInput
implements JsonSerializable<SqlMigrationTaskInput> {
    private SqlConnectionInfo sourceConnectionInfo;
    private SqlConnectionInfo targetConnectionInfo;
    private static final ClientLogger LOGGER = new ClientLogger(SqlMigrationTaskInput.class);

    public SqlConnectionInfo sourceConnectionInfo() {
        return this.sourceConnectionInfo;
    }

    public SqlMigrationTaskInput withSourceConnectionInfo(SqlConnectionInfo sourceConnectionInfo) {
        this.sourceConnectionInfo = sourceConnectionInfo;
        return this;
    }

    public SqlConnectionInfo targetConnectionInfo() {
        return this.targetConnectionInfo;
    }

    public SqlMigrationTaskInput withTargetConnectionInfo(SqlConnectionInfo targetConnectionInfo) {
        this.targetConnectionInfo = targetConnectionInfo;
        return this;
    }

    public void validate() {
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model SqlMigrationTaskInput"));
        }
        this.sourceConnectionInfo().validate();
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model SqlMigrationTaskInput"));
        }
        this.targetConnectionInfo().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo);
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo);
        return jsonWriter.writeEndObject();
    }

    public static SqlMigrationTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (SqlMigrationTaskInput)jsonReader.readObject(reader -> {
            SqlMigrationTaskInput deserializedSqlMigrationTaskInput = new SqlMigrationTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedSqlMigrationTaskInput.sourceConnectionInfo = SqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedSqlMigrationTaskInput.targetConnectionInfo = SqlConnectionInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlMigrationTaskInput;
        });
    }
}

