/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class SqlConnectionInformation
implements JsonSerializable<SqlConnectionInformation> {
    private String dataSource;
    private String authentication;
    private String username;
    private String password;
    private Boolean encryptConnection;
    private Boolean trustServerCertificate;

    public String dataSource() {
        return this.dataSource;
    }

    public SqlConnectionInformation withDataSource(String dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public String authentication() {
        return this.authentication;
    }

    public SqlConnectionInformation withAuthentication(String authentication) {
        this.authentication = authentication;
        return this;
    }

    public String username() {
        return this.username;
    }

    public SqlConnectionInformation withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public SqlConnectionInformation withPassword(String password) {
        this.password = password;
        return this;
    }

    public Boolean encryptConnection() {
        return this.encryptConnection;
    }

    public SqlConnectionInformation withEncryptConnection(Boolean encryptConnection) {
        this.encryptConnection = encryptConnection;
        return this;
    }

    public Boolean trustServerCertificate() {
        return this.trustServerCertificate;
    }

    public SqlConnectionInformation withTrustServerCertificate(Boolean trustServerCertificate) {
        this.trustServerCertificate = trustServerCertificate;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dataSource", this.dataSource);
        jsonWriter.writeStringField("authentication", this.authentication);
        jsonWriter.writeStringField("userName", this.username);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeBooleanField("encryptConnection", this.encryptConnection);
        jsonWriter.writeBooleanField("trustServerCertificate", this.trustServerCertificate);
        return jsonWriter.writeEndObject();
    }

    public static SqlConnectionInformation fromJson(JsonReader jsonReader) throws IOException {
        return (SqlConnectionInformation)jsonReader.readObject(reader -> {
            SqlConnectionInformation deserializedSqlConnectionInformation = new SqlConnectionInformation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataSource".equals(fieldName)) {
                    deserializedSqlConnectionInformation.dataSource = reader.getString();
                    continue;
                }
                if ("authentication".equals(fieldName)) {
                    deserializedSqlConnectionInformation.authentication = reader.getString();
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedSqlConnectionInformation.username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedSqlConnectionInformation.password = reader.getString();
                    continue;
                }
                if ("encryptConnection".equals(fieldName)) {
                    deserializedSqlConnectionInformation.encryptConnection = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("trustServerCertificate".equals(fieldName)) {
                    deserializedSqlConnectionInformation.trustServerCertificate = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlConnectionInformation;
        });
    }
}

