/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.AzureBlob;
import com.azure.resourcemanager.datamigration.models.SqlFileShare;
import java.io.IOException;

public final class SourceLocation
implements JsonSerializable<SourceLocation> {
    private SqlFileShare fileShare;
    private AzureBlob azureBlob;
    private String fileStorageType;

    public SqlFileShare fileShare() {
        return this.fileShare;
    }

    public SourceLocation withFileShare(SqlFileShare fileShare) {
        this.fileShare = fileShare;
        return this;
    }

    public AzureBlob azureBlob() {
        return this.azureBlob;
    }

    public SourceLocation withAzureBlob(AzureBlob azureBlob) {
        this.azureBlob = azureBlob;
        return this;
    }

    public String fileStorageType() {
        return this.fileStorageType;
    }

    public void validate() {
        if (this.fileShare() != null) {
            this.fileShare().validate();
        }
        if (this.azureBlob() != null) {
            this.azureBlob().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("fileShare", (JsonSerializable)this.fileShare);
        jsonWriter.writeJsonField("azureBlob", (JsonSerializable)this.azureBlob);
        return jsonWriter.writeEndObject();
    }

    public static SourceLocation fromJson(JsonReader jsonReader) throws IOException {
        return (SourceLocation)jsonReader.readObject(reader -> {
            SourceLocation deserializedSourceLocation = new SourceLocation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fileShare".equals(fieldName)) {
                    deserializedSourceLocation.fileShare = SqlFileShare.fromJson(reader);
                    continue;
                }
                if ("azureBlob".equals(fieldName)) {
                    deserializedSourceLocation.azureBlob = AzureBlob.fromJson(reader);
                    continue;
                }
                if ("fileStorageType".equals(fieldName)) {
                    deserializedSourceLocation.fileStorageType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceLocation;
        });
    }
}

