/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.ExecutionStatistics;
import java.io.IOException;

public final class QueryExecutionResult
implements JsonSerializable<QueryExecutionResult> {
    private String queryText;
    private Long statementsInBatch;
    private ExecutionStatistics sourceResult;
    private ExecutionStatistics targetResult;

    public String queryText() {
        return this.queryText;
    }

    public QueryExecutionResult withQueryText(String queryText) {
        this.queryText = queryText;
        return this;
    }

    public Long statementsInBatch() {
        return this.statementsInBatch;
    }

    public QueryExecutionResult withStatementsInBatch(Long statementsInBatch) {
        this.statementsInBatch = statementsInBatch;
        return this;
    }

    public ExecutionStatistics sourceResult() {
        return this.sourceResult;
    }

    public QueryExecutionResult withSourceResult(ExecutionStatistics sourceResult) {
        this.sourceResult = sourceResult;
        return this;
    }

    public ExecutionStatistics targetResult() {
        return this.targetResult;
    }

    public QueryExecutionResult withTargetResult(ExecutionStatistics targetResult) {
        this.targetResult = targetResult;
        return this;
    }

    public void validate() {
        if (this.sourceResult() != null) {
            this.sourceResult().validate();
        }
        if (this.targetResult() != null) {
            this.targetResult().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("queryText", this.queryText);
        jsonWriter.writeNumberField("statementsInBatch", (Number)this.statementsInBatch);
        jsonWriter.writeJsonField("sourceResult", (JsonSerializable)this.sourceResult);
        jsonWriter.writeJsonField("targetResult", (JsonSerializable)this.targetResult);
        return jsonWriter.writeEndObject();
    }

    public static QueryExecutionResult fromJson(JsonReader jsonReader) throws IOException {
        return (QueryExecutionResult)jsonReader.readObject(reader -> {
            QueryExecutionResult deserializedQueryExecutionResult = new QueryExecutionResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("queryText".equals(fieldName)) {
                    deserializedQueryExecutionResult.queryText = reader.getString();
                    continue;
                }
                if ("statementsInBatch".equals(fieldName)) {
                    deserializedQueryExecutionResult.statementsInBatch = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("sourceResult".equals(fieldName)) {
                    deserializedQueryExecutionResult.sourceResult = ExecutionStatistics.fromJson(reader);
                    continue;
                }
                if ("targetResult".equals(fieldName)) {
                    deserializedQueryExecutionResult.targetResult = ExecutionStatistics.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQueryExecutionResult;
        });
    }
}

