/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MongoDbThrottlingSettings
implements JsonSerializable<MongoDbThrottlingSettings> {
    private Integer minFreeCpu;
    private Integer minFreeMemoryMb;
    private Integer maxParallelism;

    public Integer minFreeCpu() {
        return this.minFreeCpu;
    }

    public MongoDbThrottlingSettings withMinFreeCpu(Integer minFreeCpu) {
        this.minFreeCpu = minFreeCpu;
        return this;
    }

    public Integer minFreeMemoryMb() {
        return this.minFreeMemoryMb;
    }

    public MongoDbThrottlingSettings withMinFreeMemoryMb(Integer minFreeMemoryMb) {
        this.minFreeMemoryMb = minFreeMemoryMb;
        return this;
    }

    public Integer maxParallelism() {
        return this.maxParallelism;
    }

    public MongoDbThrottlingSettings withMaxParallelism(Integer maxParallelism) {
        this.maxParallelism = maxParallelism;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("minFreeCpu", (Number)this.minFreeCpu);
        jsonWriter.writeNumberField("minFreeMemoryMb", (Number)this.minFreeMemoryMb);
        jsonWriter.writeNumberField("maxParallelism", (Number)this.maxParallelism);
        return jsonWriter.writeEndObject();
    }

    public static MongoDbThrottlingSettings fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbThrottlingSettings)jsonReader.readObject(reader -> {
            MongoDbThrottlingSettings deserializedMongoDbThrottlingSettings = new MongoDbThrottlingSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("minFreeCpu".equals(fieldName)) {
                    deserializedMongoDbThrottlingSettings.minFreeCpu = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("minFreeMemoryMb".equals(fieldName)) {
                    deserializedMongoDbThrottlingSettings.minFreeMemoryMb = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxParallelism".equals(fieldName)) {
                    deserializedMongoDbThrottlingSettings.maxParallelism = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDbThrottlingSettings;
        });
    }
}

