/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class MongoDbObjectInfo
implements JsonSerializable<MongoDbObjectInfo> {
    private long averageDocumentSize;
    private long dataSize;
    private long documentCount;
    private String name;
    private String qualifiedName;
    private static final ClientLogger LOGGER = new ClientLogger(MongoDbObjectInfo.class);

    public long averageDocumentSize() {
        return this.averageDocumentSize;
    }

    public MongoDbObjectInfo withAverageDocumentSize(long averageDocumentSize) {
        this.averageDocumentSize = averageDocumentSize;
        return this;
    }

    public long dataSize() {
        return this.dataSize;
    }

    public MongoDbObjectInfo withDataSize(long dataSize) {
        this.dataSize = dataSize;
        return this;
    }

    public long documentCount() {
        return this.documentCount;
    }

    public MongoDbObjectInfo withDocumentCount(long documentCount) {
        this.documentCount = documentCount;
        return this;
    }

    public String name() {
        return this.name;
    }

    public MongoDbObjectInfo withName(String name) {
        this.name = name;
        return this;
    }

    public String qualifiedName() {
        return this.qualifiedName;
    }

    public MongoDbObjectInfo withQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model MongoDbObjectInfo"));
        }
        if (this.qualifiedName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property qualifiedName in model MongoDbObjectInfo"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("averageDocumentSize", this.averageDocumentSize);
        jsonWriter.writeLongField("dataSize", this.dataSize);
        jsonWriter.writeLongField("documentCount", this.documentCount);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("qualifiedName", this.qualifiedName);
        return jsonWriter.writeEndObject();
    }

    public static MongoDbObjectInfo fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbObjectInfo)jsonReader.readObject(reader -> {
            MongoDbObjectInfo deserializedMongoDbObjectInfo = new MongoDbObjectInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("averageDocumentSize".equals(fieldName)) {
                    deserializedMongoDbObjectInfo.averageDocumentSize = reader.getLong();
                    continue;
                }
                if ("dataSize".equals(fieldName)) {
                    deserializedMongoDbObjectInfo.dataSize = reader.getLong();
                    continue;
                }
                if ("documentCount".equals(fieldName)) {
                    deserializedMongoDbObjectInfo.documentCount = reader.getLong();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMongoDbObjectInfo.name = reader.getString();
                    continue;
                }
                if ("qualifiedName".equals(fieldName)) {
                    deserializedMongoDbObjectInfo.qualifiedName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDbObjectInfo;
        });
    }
}

