/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MongoDbDatabaseProgress;
import com.azure.resourcemanager.datamigration.models.MongoDbError;
import com.azure.resourcemanager.datamigration.models.MongoDbMigrationState;
import com.azure.resourcemanager.datamigration.models.MongoDbProgress;
import com.azure.resourcemanager.datamigration.models.MongoDbProgressResultType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class MongoDbMigrationProgress
extends MongoDbProgress {
    private MongoDbProgressResultType resultType = MongoDbProgressResultType.MIGRATION;
    private Map<String, MongoDbDatabaseProgress> databases;
    private static final ClientLogger LOGGER = new ClientLogger(MongoDbMigrationProgress.class);

    @Override
    public MongoDbProgressResultType resultType() {
        return this.resultType;
    }

    public Map<String, MongoDbDatabaseProgress> databases() {
        return this.databases;
    }

    public MongoDbMigrationProgress withDatabases(Map<String, MongoDbDatabaseProgress> databases) {
        this.databases = databases;
        return this;
    }

    @Override
    public MongoDbMigrationProgress withBytesCopied(long bytesCopied) {
        super.withBytesCopied(bytesCopied);
        return this;
    }

    @Override
    public MongoDbMigrationProgress withDocumentsCopied(long documentsCopied) {
        super.withDocumentsCopied(documentsCopied);
        return this;
    }

    @Override
    public MongoDbMigrationProgress withElapsedTime(String elapsedTime) {
        super.withElapsedTime(elapsedTime);
        return this;
    }

    @Override
    public MongoDbMigrationProgress withErrors(Map<String, MongoDbError> errors) {
        super.withErrors(errors);
        return this;
    }

    @Override
    public MongoDbMigrationProgress withEventsPending(long eventsPending) {
        super.withEventsPending(eventsPending);
        return this;
    }

    @Override
    public MongoDbMigrationProgress withEventsReplayed(long eventsReplayed) {
        super.withEventsReplayed(eventsReplayed);
        return this;
    }

    @Override
    public MongoDbMigrationProgress withLastEventTime(OffsetDateTime lastEventTime) {
        super.withLastEventTime(lastEventTime);
        return this;
    }

    @Override
    public MongoDbMigrationProgress withLastReplayTime(OffsetDateTime lastReplayTime) {
        super.withLastReplayTime(lastReplayTime);
        return this;
    }

    @Override
    public MongoDbMigrationProgress withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public MongoDbMigrationProgress withQualifiedName(String qualifiedName) {
        super.withQualifiedName(qualifiedName);
        return this;
    }

    @Override
    public MongoDbMigrationProgress withState(MongoDbMigrationState state) {
        super.withState(state);
        return this;
    }

    @Override
    public MongoDbMigrationProgress withTotalBytes(long totalBytes) {
        super.withTotalBytes(totalBytes);
        return this;
    }

    @Override
    public MongoDbMigrationProgress withTotalDocuments(long totalDocuments) {
        super.withTotalDocuments(totalDocuments);
        return this;
    }

    @Override
    public void validate() {
        if (this.databases() != null) {
            this.databases().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.elapsedTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property elapsedTime in model MongoDbMigrationProgress"));
        }
        if (this.errors() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property errors in model MongoDbMigrationProgress"));
        }
        this.errors().values().forEach(e -> {
            if (e != null) {
                e.validate();
            }
        });
        if (this.state() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property state in model MongoDbMigrationProgress"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("bytesCopied", this.bytesCopied());
        jsonWriter.writeLongField("documentsCopied", this.documentsCopied());
        jsonWriter.writeStringField("elapsedTime", this.elapsedTime());
        jsonWriter.writeMapField("errors", this.errors(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeLongField("eventsPending", this.eventsPending());
        jsonWriter.writeLongField("eventsReplayed", this.eventsReplayed());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeLongField("totalBytes", this.totalBytes());
        jsonWriter.writeLongField("totalDocuments", this.totalDocuments());
        jsonWriter.writeStringField("lastEventTime", this.lastEventTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastEventTime()));
        jsonWriter.writeStringField("lastReplayTime", this.lastReplayTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastReplayTime()));
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("qualifiedName", this.qualifiedName());
        jsonWriter.writeStringField("resultType", this.resultType == null ? null : this.resultType.toString());
        jsonWriter.writeMapField("databases", this.databases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MongoDbMigrationProgress fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbMigrationProgress)jsonReader.readObject(reader -> {
            MongoDbMigrationProgress deserializedMongoDbMigrationProgress = new MongoDbMigrationProgress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("bytesCopied".equals(fieldName)) {
                    deserializedMongoDbMigrationProgress.withBytesCopied(reader.getLong());
                    continue;
                }
                if ("documentsCopied".equals(fieldName)) {
                    deserializedMongoDbMigrationProgress.withDocumentsCopied(reader.getLong());
                    continue;
                }
                if ("elapsedTime".equals(fieldName)) {
                    deserializedMongoDbMigrationProgress.withElapsedTime(reader.getString());
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    Map errors = reader.readMap(reader1 -> MongoDbError.fromJson(reader1));
                    deserializedMongoDbMigrationProgress.withErrors(errors);
                    continue;
                }
                if ("eventsPending".equals(fieldName)) {
                    deserializedMongoDbMigrationProgress.withEventsPending(reader.getLong());
                    continue;
                }
                if ("eventsReplayed".equals(fieldName)) {
                    deserializedMongoDbMigrationProgress.withEventsReplayed(reader.getLong());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMongoDbMigrationProgress.withState(MongoDbMigrationState.fromString(reader.getString()));
                    continue;
                }
                if ("totalBytes".equals(fieldName)) {
                    deserializedMongoDbMigrationProgress.withTotalBytes(reader.getLong());
                    continue;
                }
                if ("totalDocuments".equals(fieldName)) {
                    deserializedMongoDbMigrationProgress.withTotalDocuments(reader.getLong());
                    continue;
                }
                if ("lastEventTime".equals(fieldName)) {
                    deserializedMongoDbMigrationProgress.withLastEventTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("lastReplayTime".equals(fieldName)) {
                    deserializedMongoDbMigrationProgress.withLastReplayTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMongoDbMigrationProgress.withName(reader.getString());
                    continue;
                }
                if ("qualifiedName".equals(fieldName)) {
                    deserializedMongoDbMigrationProgress.withQualifiedName(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMongoDbMigrationProgress.resultType = MongoDbProgressResultType.fromString(reader.getString());
                    continue;
                }
                if ("databases".equals(fieldName)) {
                    Map databases;
                    deserializedMongoDbMigrationProgress.databases = databases = reader.readMap(reader1 -> MongoDbDatabaseProgress.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDbMigrationProgress;
        });
    }
}

