/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MongoDbCollectionInfo;
import com.azure.resourcemanager.datamigration.models.MongoDbObjectInfo;
import java.io.IOException;
import java.util.List;

public final class MongoDbDatabaseInfo
extends MongoDbObjectInfo {
    private List<MongoDbCollectionInfo> collections;
    private boolean supportsSharding;
    private static final ClientLogger LOGGER = new ClientLogger(MongoDbDatabaseInfo.class);

    public List<MongoDbCollectionInfo> collections() {
        return this.collections;
    }

    public MongoDbDatabaseInfo withCollections(List<MongoDbCollectionInfo> collections) {
        this.collections = collections;
        return this;
    }

    public boolean supportsSharding() {
        return this.supportsSharding;
    }

    public MongoDbDatabaseInfo withSupportsSharding(boolean supportsSharding) {
        this.supportsSharding = supportsSharding;
        return this;
    }

    @Override
    public MongoDbDatabaseInfo withAverageDocumentSize(long averageDocumentSize) {
        super.withAverageDocumentSize(averageDocumentSize);
        return this;
    }

    @Override
    public MongoDbDatabaseInfo withDataSize(long dataSize) {
        super.withDataSize(dataSize);
        return this;
    }

    @Override
    public MongoDbDatabaseInfo withDocumentCount(long documentCount) {
        super.withDocumentCount(documentCount);
        return this;
    }

    @Override
    public MongoDbDatabaseInfo withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public MongoDbDatabaseInfo withQualifiedName(String qualifiedName) {
        super.withQualifiedName(qualifiedName);
        return this;
    }

    @Override
    public void validate() {
        if (this.collections() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property collections in model MongoDbDatabaseInfo"));
        }
        this.collections().forEach(e -> e.validate());
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model MongoDbDatabaseInfo"));
        }
        if (this.qualifiedName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property qualifiedName in model MongoDbDatabaseInfo"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("averageDocumentSize", this.averageDocumentSize());
        jsonWriter.writeLongField("dataSize", this.dataSize());
        jsonWriter.writeLongField("documentCount", this.documentCount());
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("qualifiedName", this.qualifiedName());
        jsonWriter.writeArrayField("collections", this.collections, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("supportsSharding", this.supportsSharding);
        return jsonWriter.writeEndObject();
    }

    public static MongoDbDatabaseInfo fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbDatabaseInfo)jsonReader.readObject(reader -> {
            MongoDbDatabaseInfo deserializedMongoDbDatabaseInfo = new MongoDbDatabaseInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("averageDocumentSize".equals(fieldName)) {
                    deserializedMongoDbDatabaseInfo.withAverageDocumentSize(reader.getLong());
                    continue;
                }
                if ("dataSize".equals(fieldName)) {
                    deserializedMongoDbDatabaseInfo.withDataSize(reader.getLong());
                    continue;
                }
                if ("documentCount".equals(fieldName)) {
                    deserializedMongoDbDatabaseInfo.withDocumentCount(reader.getLong());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMongoDbDatabaseInfo.withName(reader.getString());
                    continue;
                }
                if ("qualifiedName".equals(fieldName)) {
                    deserializedMongoDbDatabaseInfo.withQualifiedName(reader.getString());
                    continue;
                }
                if ("collections".equals(fieldName)) {
                    List collections;
                    deserializedMongoDbDatabaseInfo.collections = collections = reader.readArray(reader1 -> MongoDbCollectionInfo.fromJson(reader1));
                    continue;
                }
                if ("supportsSharding".equals(fieldName)) {
                    deserializedMongoDbDatabaseInfo.supportsSharding = reader.getBoolean();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDbDatabaseInfo;
        });
    }
}

