/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.CommandPropertiesInner;
import com.azure.resourcemanager.datamigration.models.CommandState;
import com.azure.resourcemanager.datamigration.models.CommandType;
import com.azure.resourcemanager.datamigration.models.MigrateSyncCompleteCommandInput;
import com.azure.resourcemanager.datamigration.models.MigrateSyncCompleteCommandOutput;
import java.io.IOException;
import java.util.List;

public final class MigrateSyncCompleteCommandProperties
extends CommandPropertiesInner {
    private CommandType commandType = CommandType.MIGRATE_SYNC_COMPLETE_DATABASE;
    private MigrateSyncCompleteCommandInput input;
    private MigrateSyncCompleteCommandOutput output;
    private String commandId;
    private CommandState state;
    private List<ManagementError> errors;

    @Override
    public CommandType commandType() {
        return this.commandType;
    }

    public MigrateSyncCompleteCommandInput input() {
        return this.input;
    }

    public MigrateSyncCompleteCommandProperties withInput(MigrateSyncCompleteCommandInput input) {
        this.input = input;
        return this;
    }

    public MigrateSyncCompleteCommandOutput output() {
        return this.output;
    }

    public String commandId() {
        return this.commandId;
    }

    public MigrateSyncCompleteCommandProperties withCommandId(String commandId) {
        this.commandId = commandId;
        return this;
    }

    @Override
    public CommandState state() {
        return this.state;
    }

    @Override
    public List<ManagementError> errors() {
        return this.errors;
    }

    @Override
    public void validate() {
        if (this.input() != null) {
            this.input().validate();
        }
        if (this.output() != null) {
            this.output().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("commandType", this.commandType == null ? null : this.commandType.toString());
        jsonWriter.writeJsonField("input", (JsonSerializable)this.input);
        jsonWriter.writeStringField("commandId", this.commandId);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSyncCompleteCommandProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSyncCompleteCommandProperties)jsonReader.readObject(reader -> {
            MigrateSyncCompleteCommandProperties deserializedMigrateSyncCompleteCommandProperties = new MigrateSyncCompleteCommandProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedMigrateSyncCompleteCommandProperties.errors = errors = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMigrateSyncCompleteCommandProperties.state = CommandState.fromString(reader.getString());
                    continue;
                }
                if ("commandType".equals(fieldName)) {
                    deserializedMigrateSyncCompleteCommandProperties.commandType = CommandType.fromString(reader.getString());
                    continue;
                }
                if ("input".equals(fieldName)) {
                    deserializedMigrateSyncCompleteCommandProperties.input = MigrateSyncCompleteCommandInput.fromJson(reader);
                    continue;
                }
                if ("output".equals(fieldName)) {
                    deserializedMigrateSyncCompleteCommandProperties.output = MigrateSyncCompleteCommandOutput.fromJson(reader);
                    continue;
                }
                if ("commandId".equals(fieldName)) {
                    deserializedMigrateSyncCompleteCommandProperties.commandId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSyncCompleteCommandProperties;
        });
    }
}

