/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class MigrateSyncCompleteCommandInput
implements JsonSerializable<MigrateSyncCompleteCommandInput> {
    private String databaseName;
    private OffsetDateTime commitTimestamp;
    private static final ClientLogger LOGGER = new ClientLogger(MigrateSyncCompleteCommandInput.class);

    public String databaseName() {
        return this.databaseName;
    }

    public MigrateSyncCompleteCommandInput withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public OffsetDateTime commitTimestamp() {
        return this.commitTimestamp;
    }

    public MigrateSyncCompleteCommandInput withCommitTimestamp(OffsetDateTime commitTimestamp) {
        this.commitTimestamp = commitTimestamp;
        return this;
    }

    public void validate() {
        if (this.databaseName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property databaseName in model MigrateSyncCompleteCommandInput"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeStringField("commitTimeStamp", this.commitTimestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.commitTimestamp));
        return jsonWriter.writeEndObject();
    }

    public static MigrateSyncCompleteCommandInput fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSyncCompleteCommandInput)jsonReader.readObject(reader -> {
            MigrateSyncCompleteCommandInput deserializedMigrateSyncCompleteCommandInput = new MigrateSyncCompleteCommandInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("databaseName".equals(fieldName)) {
                    deserializedMigrateSyncCompleteCommandInput.databaseName = reader.getString();
                    continue;
                }
                if ("commitTimeStamp".equals(fieldName)) {
                    deserializedMigrateSyncCompleteCommandInput.commitTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSyncCompleteCommandInput;
        });
    }
}

