/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.AzureActiveDirectoryApp;
import com.azure.resourcemanager.datamigration.models.FileShare;
import com.azure.resourcemanager.datamigration.models.MiSqlConnectionInfo;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlMIDatabaseInput;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInfo;
import com.azure.resourcemanager.datamigration.models.SqlServerSqlMISyncTaskInput;
import java.io.IOException;
import java.util.List;

public final class MigrateSqlServerSqlMISyncTaskInput
extends SqlServerSqlMISyncTaskInput {
    private Float numberOfParallelDatabaseMigrations;
    private static final ClientLogger LOGGER = new ClientLogger(MigrateSqlServerSqlMISyncTaskInput.class);

    public Float numberOfParallelDatabaseMigrations() {
        return this.numberOfParallelDatabaseMigrations;
    }

    public MigrateSqlServerSqlMISyncTaskInput withNumberOfParallelDatabaseMigrations(Float numberOfParallelDatabaseMigrations) {
        this.numberOfParallelDatabaseMigrations = numberOfParallelDatabaseMigrations;
        return this;
    }

    @Override
    public MigrateSqlServerSqlMISyncTaskInput withSelectedDatabases(List<MigrateSqlServerSqlMIDatabaseInput> selectedDatabases) {
        super.withSelectedDatabases(selectedDatabases);
        return this;
    }

    @Override
    public MigrateSqlServerSqlMISyncTaskInput withBackupFileShare(FileShare backupFileShare) {
        super.withBackupFileShare(backupFileShare);
        return this;
    }

    @Override
    public MigrateSqlServerSqlMISyncTaskInput withStorageResourceId(String storageResourceId) {
        super.withStorageResourceId(storageResourceId);
        return this;
    }

    @Override
    public MigrateSqlServerSqlMISyncTaskInput withSourceConnectionInfo(SqlConnectionInfo sourceConnectionInfo) {
        super.withSourceConnectionInfo(sourceConnectionInfo);
        return this;
    }

    @Override
    public MigrateSqlServerSqlMISyncTaskInput withTargetConnectionInfo(MiSqlConnectionInfo targetConnectionInfo) {
        super.withTargetConnectionInfo(targetConnectionInfo);
        return this;
    }

    @Override
    public MigrateSqlServerSqlMISyncTaskInput withAzureApp(AzureActiveDirectoryApp azureApp) {
        super.withAzureApp(azureApp);
        return this;
    }

    @Override
    public void validate() {
        if (this.selectedDatabases() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectedDatabases in model MigrateSqlServerSqlMISyncTaskInput"));
        }
        this.selectedDatabases().forEach(e -> e.validate());
        if (this.backupFileShare() != null) {
            this.backupFileShare().validate();
        }
        if (this.storageResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageResourceId in model MigrateSqlServerSqlMISyncTaskInput"));
        }
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model MigrateSqlServerSqlMISyncTaskInput"));
        }
        this.sourceConnectionInfo().validate();
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model MigrateSqlServerSqlMISyncTaskInput"));
        }
        this.targetConnectionInfo().validate();
        if (this.azureApp() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property azureApp in model MigrateSqlServerSqlMISyncTaskInput"));
        }
        this.azureApp().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("selectedDatabases", this.selectedDatabases(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("storageResourceId", this.storageResourceId());
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo());
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo());
        jsonWriter.writeJsonField("azureApp", (JsonSerializable)this.azureApp());
        jsonWriter.writeJsonField("backupFileShare", (JsonSerializable)this.backupFileShare());
        jsonWriter.writeNumberField("numberOfParallelDatabaseMigrations", (Number)this.numberOfParallelDatabaseMigrations);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSqlServerSqlMISyncTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSqlServerSqlMISyncTaskInput)jsonReader.readObject(reader -> {
            MigrateSqlServerSqlMISyncTaskInput deserializedMigrateSqlServerSqlMISyncTaskInput = new MigrateSqlServerSqlMISyncTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("selectedDatabases".equals(fieldName)) {
                    List selectedDatabases = reader.readArray(reader1 -> MigrateSqlServerSqlMIDatabaseInput.fromJson(reader1));
                    deserializedMigrateSqlServerSqlMISyncTaskInput.withSelectedDatabases(selectedDatabases);
                    continue;
                }
                if ("storageResourceId".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskInput.withStorageResourceId(reader.getString());
                    continue;
                }
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskInput.withSourceConnectionInfo(SqlConnectionInfo.fromJson(reader));
                    continue;
                }
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskInput.withTargetConnectionInfo(MiSqlConnectionInfo.fromJson(reader));
                    continue;
                }
                if ("azureApp".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskInput.withAzureApp(AzureActiveDirectoryApp.fromJson(reader));
                    continue;
                }
                if ("backupFileShare".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskInput.withBackupFileShare(FileShare.fromJson(reader));
                    continue;
                }
                if ("numberOfParallelDatabaseMigrations".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskInput.numberOfParallelDatabaseMigrations = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSqlServerSqlMISyncTaskInput;
        });
    }
}

