/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.CommandPropertiesInner;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlDbTaskInput;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlDbTaskOutput;
import com.azure.resourcemanager.datamigration.models.ProjectTaskProperties;
import com.azure.resourcemanager.datamigration.models.TaskState;
import com.azure.resourcemanager.datamigration.models.TaskType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class MigrateSqlServerSqlDbTaskProperties
extends ProjectTaskProperties {
    private TaskType taskType = TaskType.MIGRATE_SQL_SERVER_SQL_DB;
    private MigrateSqlServerSqlDbTaskInput input;
    private List<MigrateSqlServerSqlDbTaskOutput> output;
    private String taskId;
    private Boolean isCloneable;
    private String createdOn;

    @Override
    public TaskType taskType() {
        return this.taskType;
    }

    public MigrateSqlServerSqlDbTaskInput input() {
        return this.input;
    }

    public MigrateSqlServerSqlDbTaskProperties withInput(MigrateSqlServerSqlDbTaskInput input) {
        this.input = input;
        return this;
    }

    public List<MigrateSqlServerSqlDbTaskOutput> output() {
        return this.output;
    }

    public String taskId() {
        return this.taskId;
    }

    public MigrateSqlServerSqlDbTaskProperties withTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public Boolean isCloneable() {
        return this.isCloneable;
    }

    public MigrateSqlServerSqlDbTaskProperties withIsCloneable(Boolean isCloneable) {
        this.isCloneable = isCloneable;
        return this;
    }

    public String createdOn() {
        return this.createdOn;
    }

    public MigrateSqlServerSqlDbTaskProperties withCreatedOn(String createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    @Override
    public MigrateSqlServerSqlDbTaskProperties withClientData(Map<String, String> clientData) {
        super.withClientData(clientData);
        return this;
    }

    @Override
    public void validate() {
        if (this.input() != null) {
            this.input().validate();
        }
        if (this.output() != null) {
            this.output().forEach(e -> e.validate());
        }
        if (this.commands() != null) {
            this.commands().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("clientData", this.clientData(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("taskType", this.taskType == null ? null : this.taskType.toString());
        jsonWriter.writeJsonField("input", (JsonSerializable)this.input);
        jsonWriter.writeStringField("taskId", this.taskId);
        jsonWriter.writeBooleanField("isCloneable", this.isCloneable);
        jsonWriter.writeStringField("createdOn", this.createdOn);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSqlServerSqlDbTaskProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSqlServerSqlDbTaskProperties)jsonReader.readObject(reader -> {
            MigrateSqlServerSqlDbTaskProperties deserializedMigrateSqlServerSqlDbTaskProperties = new MigrateSqlServerSqlDbTaskProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    deserializedMigrateSqlServerSqlDbTaskProperties.withErrors(errors);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskProperties.withState(TaskState.fromString(reader.getString()));
                    continue;
                }
                if ("commands".equals(fieldName)) {
                    List commands = reader.readArray(reader1 -> CommandPropertiesInner.fromJson(reader1));
                    deserializedMigrateSqlServerSqlDbTaskProperties.withCommands(commands);
                    continue;
                }
                if ("clientData".equals(fieldName)) {
                    Map clientData = reader.readMap(reader1 -> reader1.getString());
                    deserializedMigrateSqlServerSqlDbTaskProperties.withClientData(clientData);
                    continue;
                }
                if ("taskType".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskProperties.taskType = TaskType.fromString(reader.getString());
                    continue;
                }
                if ("input".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskProperties.input = MigrateSqlServerSqlDbTaskInput.fromJson(reader);
                    continue;
                }
                if ("output".equals(fieldName)) {
                    List output;
                    deserializedMigrateSqlServerSqlDbTaskProperties.output = output = reader.readArray(reader1 -> MigrateSqlServerSqlDbTaskOutput.fromJson(reader1));
                    continue;
                }
                if ("taskId".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskProperties.taskId = reader.getString();
                    continue;
                }
                if ("isCloneable".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskProperties.isCloneable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("createdOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskProperties.createdOn = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSqlServerSqlDbTaskProperties;
        });
    }
}

