/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlDbDatabaseInput;
import com.azure.resourcemanager.datamigration.models.MigrationValidationOptions;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInfo;
import com.azure.resourcemanager.datamigration.models.SqlMigrationTaskInput;
import java.io.IOException;
import java.util.List;

public final class MigrateSqlServerSqlDbTaskInput
extends SqlMigrationTaskInput {
    private List<MigrateSqlServerSqlDbDatabaseInput> selectedDatabases;
    private MigrationValidationOptions validationOptions;
    private String startedOn;
    private String encryptedKeyForSecureFields;
    private static final ClientLogger LOGGER = new ClientLogger(MigrateSqlServerSqlDbTaskInput.class);

    public List<MigrateSqlServerSqlDbDatabaseInput> selectedDatabases() {
        return this.selectedDatabases;
    }

    public MigrateSqlServerSqlDbTaskInput withSelectedDatabases(List<MigrateSqlServerSqlDbDatabaseInput> selectedDatabases) {
        this.selectedDatabases = selectedDatabases;
        return this;
    }

    public MigrationValidationOptions validationOptions() {
        return this.validationOptions;
    }

    public MigrateSqlServerSqlDbTaskInput withValidationOptions(MigrationValidationOptions validationOptions) {
        this.validationOptions = validationOptions;
        return this;
    }

    public String startedOn() {
        return this.startedOn;
    }

    public MigrateSqlServerSqlDbTaskInput withStartedOn(String startedOn) {
        this.startedOn = startedOn;
        return this;
    }

    public String encryptedKeyForSecureFields() {
        return this.encryptedKeyForSecureFields;
    }

    public MigrateSqlServerSqlDbTaskInput withEncryptedKeyForSecureFields(String encryptedKeyForSecureFields) {
        this.encryptedKeyForSecureFields = encryptedKeyForSecureFields;
        return this;
    }

    @Override
    public MigrateSqlServerSqlDbTaskInput withSourceConnectionInfo(SqlConnectionInfo sourceConnectionInfo) {
        super.withSourceConnectionInfo(sourceConnectionInfo);
        return this;
    }

    @Override
    public MigrateSqlServerSqlDbTaskInput withTargetConnectionInfo(SqlConnectionInfo targetConnectionInfo) {
        super.withTargetConnectionInfo(targetConnectionInfo);
        return this;
    }

    @Override
    public void validate() {
        if (this.selectedDatabases() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectedDatabases in model MigrateSqlServerSqlDbTaskInput"));
        }
        this.selectedDatabases().forEach(e -> e.validate());
        if (this.validationOptions() != null) {
            this.validationOptions().validate();
        }
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model MigrateSqlServerSqlDbTaskInput"));
        }
        this.sourceConnectionInfo().validate();
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model MigrateSqlServerSqlDbTaskInput"));
        }
        this.targetConnectionInfo().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo());
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo());
        jsonWriter.writeArrayField("selectedDatabases", this.selectedDatabases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("validationOptions", (JsonSerializable)this.validationOptions);
        jsonWriter.writeStringField("startedOn", this.startedOn);
        jsonWriter.writeStringField("encryptedKeyForSecureFields", this.encryptedKeyForSecureFields);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSqlServerSqlDbTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSqlServerSqlDbTaskInput)jsonReader.readObject(reader -> {
            MigrateSqlServerSqlDbTaskInput deserializedMigrateSqlServerSqlDbTaskInput = new MigrateSqlServerSqlDbTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskInput.withSourceConnectionInfo(SqlConnectionInfo.fromJson(reader));
                    continue;
                }
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskInput.withTargetConnectionInfo(SqlConnectionInfo.fromJson(reader));
                    continue;
                }
                if ("selectedDatabases".equals(fieldName)) {
                    List selectedDatabases;
                    deserializedMigrateSqlServerSqlDbTaskInput.selectedDatabases = selectedDatabases = reader.readArray(reader1 -> MigrateSqlServerSqlDbDatabaseInput.fromJson(reader1));
                    continue;
                }
                if ("validationOptions".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskInput.validationOptions = MigrationValidationOptions.fromJson(reader);
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskInput.startedOn = reader.getString();
                    continue;
                }
                if ("encryptedKeyForSecureFields".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskInput.encryptedKeyForSecureFields = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSqlServerSqlDbTaskInput;
        });
    }
}

