/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrateSchemaSqlServerSqlDbDatabaseInput;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInfo;
import com.azure.resourcemanager.datamigration.models.SqlMigrationTaskInput;
import java.io.IOException;
import java.util.List;

public final class MigrateSchemaSqlServerSqlDbTaskInput
extends SqlMigrationTaskInput {
    private List<MigrateSchemaSqlServerSqlDbDatabaseInput> selectedDatabases;
    private String encryptedKeyForSecureFields;
    private String startedOn;
    private static final ClientLogger LOGGER = new ClientLogger(MigrateSchemaSqlServerSqlDbTaskInput.class);

    public List<MigrateSchemaSqlServerSqlDbDatabaseInput> selectedDatabases() {
        return this.selectedDatabases;
    }

    public MigrateSchemaSqlServerSqlDbTaskInput withSelectedDatabases(List<MigrateSchemaSqlServerSqlDbDatabaseInput> selectedDatabases) {
        this.selectedDatabases = selectedDatabases;
        return this;
    }

    public String encryptedKeyForSecureFields() {
        return this.encryptedKeyForSecureFields;
    }

    public MigrateSchemaSqlServerSqlDbTaskInput withEncryptedKeyForSecureFields(String encryptedKeyForSecureFields) {
        this.encryptedKeyForSecureFields = encryptedKeyForSecureFields;
        return this;
    }

    public String startedOn() {
        return this.startedOn;
    }

    public MigrateSchemaSqlServerSqlDbTaskInput withStartedOn(String startedOn) {
        this.startedOn = startedOn;
        return this;
    }

    @Override
    public MigrateSchemaSqlServerSqlDbTaskInput withSourceConnectionInfo(SqlConnectionInfo sourceConnectionInfo) {
        super.withSourceConnectionInfo(sourceConnectionInfo);
        return this;
    }

    @Override
    public MigrateSchemaSqlServerSqlDbTaskInput withTargetConnectionInfo(SqlConnectionInfo targetConnectionInfo) {
        super.withTargetConnectionInfo(targetConnectionInfo);
        return this;
    }

    @Override
    public void validate() {
        if (this.selectedDatabases() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectedDatabases in model MigrateSchemaSqlServerSqlDbTaskInput"));
        }
        this.selectedDatabases().forEach(e -> e.validate());
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model MigrateSchemaSqlServerSqlDbTaskInput"));
        }
        this.sourceConnectionInfo().validate();
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model MigrateSchemaSqlServerSqlDbTaskInput"));
        }
        this.targetConnectionInfo().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo());
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo());
        jsonWriter.writeArrayField("selectedDatabases", this.selectedDatabases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("encryptedKeyForSecureFields", this.encryptedKeyForSecureFields);
        jsonWriter.writeStringField("startedOn", this.startedOn);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSchemaSqlServerSqlDbTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSchemaSqlServerSqlDbTaskInput)jsonReader.readObject(reader -> {
            MigrateSchemaSqlServerSqlDbTaskInput deserializedMigrateSchemaSqlServerSqlDbTaskInput = new MigrateSchemaSqlServerSqlDbTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskInput.withSourceConnectionInfo(SqlConnectionInfo.fromJson(reader));
                    continue;
                }
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskInput.withTargetConnectionInfo(SqlConnectionInfo.fromJson(reader));
                    continue;
                }
                if ("selectedDatabases".equals(fieldName)) {
                    List selectedDatabases;
                    deserializedMigrateSchemaSqlServerSqlDbTaskInput.selectedDatabases = selectedDatabases = reader.readArray(reader1 -> MigrateSchemaSqlServerSqlDbDatabaseInput.fromJson(reader1));
                    continue;
                }
                if ("encryptedKeyForSecureFields".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskInput.encryptedKeyForSecureFields = reader.getString();
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskInput.startedOn = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSchemaSqlServerSqlDbTaskInput;
        });
    }
}

