/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import com.azure.resourcemanager.datamigration.models.SyncMigrationDatabaseErrorEvent;
import java.io.IOException;
import java.util.List;

public final class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError
extends MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput {
    private String resultType = "ErrorOutput";
    private ReportableException error;
    private List<SyncMigrationDatabaseErrorEvent> events;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public ReportableException error() {
        return this.error;
    }

    public List<SyncMigrationDatabaseErrorEvent> events() {
        return this.events;
    }

    public MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError withEvents(List<SyncMigrationDatabaseErrorEvent> events) {
        this.events = events;
        return this;
    }

    @Override
    public void validate() {
        if (this.error() != null) {
            this.error().validate();
        }
        if (this.events() != null) {
            this.events().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        jsonWriter.writeArrayField("events", this.events, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError fromJson(JsonReader jsonReader) throws IOException {
        return (MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError)jsonReader.readObject(reader -> {
            MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError = new MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError.resultType = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError.error = ReportableException.fromJson(reader);
                    continue;
                }
                if ("events".equals(fieldName)) {
                    List events;
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError.events = events = reader.readArray(reader1 -> SyncMigrationDatabaseErrorEvent.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputError;
        });
    }
}

