/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.CommandPropertiesInner;
import com.azure.resourcemanager.datamigration.models.GetUserTablesSqlTaskInput;
import com.azure.resourcemanager.datamigration.models.GetUserTablesSqlTaskOutput;
import com.azure.resourcemanager.datamigration.models.ProjectTaskProperties;
import com.azure.resourcemanager.datamigration.models.TaskState;
import com.azure.resourcemanager.datamigration.models.TaskType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class GetUserTablesSqlTaskProperties
extends ProjectTaskProperties {
    private TaskType taskType = TaskType.GET_USER_TABLES_SQL;
    private GetUserTablesSqlTaskInput input;
    private List<GetUserTablesSqlTaskOutput> output;
    private String taskId;

    @Override
    public TaskType taskType() {
        return this.taskType;
    }

    public GetUserTablesSqlTaskInput input() {
        return this.input;
    }

    public GetUserTablesSqlTaskProperties withInput(GetUserTablesSqlTaskInput input) {
        this.input = input;
        return this;
    }

    public List<GetUserTablesSqlTaskOutput> output() {
        return this.output;
    }

    public String taskId() {
        return this.taskId;
    }

    public GetUserTablesSqlTaskProperties withTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    @Override
    public GetUserTablesSqlTaskProperties withClientData(Map<String, String> clientData) {
        super.withClientData(clientData);
        return this;
    }

    @Override
    public void validate() {
        if (this.input() != null) {
            this.input().validate();
        }
        if (this.output() != null) {
            this.output().forEach(e -> e.validate());
        }
        if (this.commands() != null) {
            this.commands().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("clientData", this.clientData(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("taskType", this.taskType == null ? null : this.taskType.toString());
        jsonWriter.writeJsonField("input", (JsonSerializable)this.input);
        jsonWriter.writeStringField("taskId", this.taskId);
        return jsonWriter.writeEndObject();
    }

    public static GetUserTablesSqlTaskProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GetUserTablesSqlTaskProperties)jsonReader.readObject(reader -> {
            GetUserTablesSqlTaskProperties deserializedGetUserTablesSqlTaskProperties = new GetUserTablesSqlTaskProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    deserializedGetUserTablesSqlTaskProperties.withErrors(errors);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedGetUserTablesSqlTaskProperties.withState(TaskState.fromString(reader.getString()));
                    continue;
                }
                if ("commands".equals(fieldName)) {
                    List commands = reader.readArray(reader1 -> CommandPropertiesInner.fromJson(reader1));
                    deserializedGetUserTablesSqlTaskProperties.withCommands(commands);
                    continue;
                }
                if ("clientData".equals(fieldName)) {
                    Map clientData = reader.readMap(reader1 -> reader1.getString());
                    deserializedGetUserTablesSqlTaskProperties.withClientData(clientData);
                    continue;
                }
                if ("taskType".equals(fieldName)) {
                    deserializedGetUserTablesSqlTaskProperties.taskType = TaskType.fromString(reader.getString());
                    continue;
                }
                if ("input".equals(fieldName)) {
                    deserializedGetUserTablesSqlTaskProperties.input = GetUserTablesSqlTaskInput.fromJson(reader);
                    continue;
                }
                if ("output".equals(fieldName)) {
                    List output;
                    deserializedGetUserTablesSqlTaskProperties.output = output = reader.readArray(reader1 -> GetUserTablesSqlTaskOutput.fromJson(reader1));
                    continue;
                }
                if ("taskId".equals(fieldName)) {
                    deserializedGetUserTablesSqlTaskProperties.taskId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGetUserTablesSqlTaskProperties;
        });
    }
}

