/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class FileShare
implements JsonSerializable<FileShare> {
    private String username;
    private String password;
    private String path;
    private static final ClientLogger LOGGER = new ClientLogger(FileShare.class);

    public String username() {
        return this.username;
    }

    public FileShare withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public FileShare withPassword(String password) {
        this.password = password;
        return this;
    }

    public String path() {
        return this.path;
    }

    public FileShare withPath(String path) {
        this.path = path;
        return this;
    }

    public void validate() {
        if (this.path() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property path in model FileShare"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("userName", this.username);
        jsonWriter.writeStringField("password", this.password);
        return jsonWriter.writeEndObject();
    }

    public static FileShare fromJson(JsonReader jsonReader) throws IOException {
        return (FileShare)jsonReader.readObject(reader -> {
            FileShare deserializedFileShare = new FileShare();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("path".equals(fieldName)) {
                    deserializedFileShare.path = reader.getString();
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedFileShare.username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedFileShare.password = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFileShare;
        });
    }
}

