/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DatabaseInfo
implements JsonSerializable<DatabaseInfo> {
    private String sourceDatabaseName;
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseInfo.class);

    public String sourceDatabaseName() {
        return this.sourceDatabaseName;
    }

    public DatabaseInfo withSourceDatabaseName(String sourceDatabaseName) {
        this.sourceDatabaseName = sourceDatabaseName;
        return this;
    }

    public void validate() {
        if (this.sourceDatabaseName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceDatabaseName in model DatabaseInfo"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceDatabaseName", this.sourceDatabaseName);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseInfo fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseInfo)jsonReader.readObject(reader -> {
            DatabaseInfo deserializedDatabaseInfo = new DatabaseInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceDatabaseName".equals(fieldName)) {
                    deserializedDatabaseInfo.sourceDatabaseName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseInfo;
        });
    }
}

