/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class CopyProgressDetails
implements JsonSerializable<CopyProgressDetails> {
    private String tableName;
    private String status;
    private String parallelCopyType;
    private Integer usedParallelCopies;
    private Long dataRead;
    private Long dataWritten;
    private Long rowsRead;
    private Long rowsCopied;
    private OffsetDateTime copyStart;
    private Double copyThroughput;
    private Integer copyDuration;

    public String tableName() {
        return this.tableName;
    }

    public String status() {
        return this.status;
    }

    public String parallelCopyType() {
        return this.parallelCopyType;
    }

    public Integer usedParallelCopies() {
        return this.usedParallelCopies;
    }

    public Long dataRead() {
        return this.dataRead;
    }

    public Long dataWritten() {
        return this.dataWritten;
    }

    public Long rowsRead() {
        return this.rowsRead;
    }

    public Long rowsCopied() {
        return this.rowsCopied;
    }

    public OffsetDateTime copyStart() {
        return this.copyStart;
    }

    public Double copyThroughput() {
        return this.copyThroughput;
    }

    public Integer copyDuration() {
        return this.copyDuration;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static CopyProgressDetails fromJson(JsonReader jsonReader) throws IOException {
        return (CopyProgressDetails)jsonReader.readObject(reader -> {
            CopyProgressDetails deserializedCopyProgressDetails = new CopyProgressDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tableName".equals(fieldName)) {
                    deserializedCopyProgressDetails.tableName = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedCopyProgressDetails.status = reader.getString();
                    continue;
                }
                if ("parallelCopyType".equals(fieldName)) {
                    deserializedCopyProgressDetails.parallelCopyType = reader.getString();
                    continue;
                }
                if ("usedParallelCopies".equals(fieldName)) {
                    deserializedCopyProgressDetails.usedParallelCopies = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("dataRead".equals(fieldName)) {
                    deserializedCopyProgressDetails.dataRead = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("dataWritten".equals(fieldName)) {
                    deserializedCopyProgressDetails.dataWritten = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("rowsRead".equals(fieldName)) {
                    deserializedCopyProgressDetails.rowsRead = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("rowsCopied".equals(fieldName)) {
                    deserializedCopyProgressDetails.rowsCopied = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("copyStart".equals(fieldName)) {
                    deserializedCopyProgressDetails.copyStart = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("copyThroughput".equals(fieldName)) {
                    deserializedCopyProgressDetails.copyThroughput = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("copyDuration".equals(fieldName)) {
                    deserializedCopyProgressDetails.copyDuration = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCopyProgressDetails;
        });
    }
}

