/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInfo;
import java.io.IOException;

public final class ConnectToTargetSqlDbTaskInput
implements JsonSerializable<ConnectToTargetSqlDbTaskInput> {
    private SqlConnectionInfo targetConnectionInfo;
    private Boolean queryObjectCounts;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectToTargetSqlDbTaskInput.class);

    public SqlConnectionInfo targetConnectionInfo() {
        return this.targetConnectionInfo;
    }

    public ConnectToTargetSqlDbTaskInput withTargetConnectionInfo(SqlConnectionInfo targetConnectionInfo) {
        this.targetConnectionInfo = targetConnectionInfo;
        return this;
    }

    public Boolean queryObjectCounts() {
        return this.queryObjectCounts;
    }

    public ConnectToTargetSqlDbTaskInput withQueryObjectCounts(Boolean queryObjectCounts) {
        this.queryObjectCounts = queryObjectCounts;
        return this;
    }

    public void validate() {
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model ConnectToTargetSqlDbTaskInput"));
        }
        this.targetConnectionInfo().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo);
        jsonWriter.writeBooleanField("queryObjectCounts", this.queryObjectCounts);
        return jsonWriter.writeEndObject();
    }

    public static ConnectToTargetSqlDbTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectToTargetSqlDbTaskInput)jsonReader.readObject(reader -> {
            ConnectToTargetSqlDbTaskInput deserializedConnectToTargetSqlDbTaskInput = new ConnectToTargetSqlDbTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedConnectToTargetSqlDbTaskInput.targetConnectionInfo = SqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("queryObjectCounts".equals(fieldName)) {
                    deserializedConnectToTargetSqlDbTaskInput.queryObjectCounts = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectToTargetSqlDbTaskInput;
        });
    }
}

