/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.CommandPropertiesInner;
import com.azure.resourcemanager.datamigration.models.ConnectToTargetSqlDbSyncTaskInput;
import com.azure.resourcemanager.datamigration.models.ConnectToTargetSqlDbTaskOutput;
import com.azure.resourcemanager.datamigration.models.ProjectTaskProperties;
import com.azure.resourcemanager.datamigration.models.TaskState;
import com.azure.resourcemanager.datamigration.models.TaskType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ConnectToTargetSqlDbSyncTaskProperties
extends ProjectTaskProperties {
    private TaskType taskType = TaskType.CONNECT_TO_TARGET_SQL_DB_SYNC;
    private ConnectToTargetSqlDbSyncTaskInput input;
    private List<ConnectToTargetSqlDbTaskOutput> output;

    @Override
    public TaskType taskType() {
        return this.taskType;
    }

    public ConnectToTargetSqlDbSyncTaskInput input() {
        return this.input;
    }

    public ConnectToTargetSqlDbSyncTaskProperties withInput(ConnectToTargetSqlDbSyncTaskInput input) {
        this.input = input;
        return this;
    }

    public List<ConnectToTargetSqlDbTaskOutput> output() {
        return this.output;
    }

    @Override
    public ConnectToTargetSqlDbSyncTaskProperties withClientData(Map<String, String> clientData) {
        super.withClientData(clientData);
        return this;
    }

    @Override
    public void validate() {
        if (this.input() != null) {
            this.input().validate();
        }
        if (this.output() != null) {
            this.output().forEach(e -> e.validate());
        }
        if (this.commands() != null) {
            this.commands().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("clientData", this.clientData(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("taskType", this.taskType == null ? null : this.taskType.toString());
        jsonWriter.writeJsonField("input", (JsonSerializable)this.input);
        return jsonWriter.writeEndObject();
    }

    public static ConnectToTargetSqlDbSyncTaskProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectToTargetSqlDbSyncTaskProperties)jsonReader.readObject(reader -> {
            ConnectToTargetSqlDbSyncTaskProperties deserializedConnectToTargetSqlDbSyncTaskProperties = new ConnectToTargetSqlDbSyncTaskProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    deserializedConnectToTargetSqlDbSyncTaskProperties.withErrors(errors);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedConnectToTargetSqlDbSyncTaskProperties.withState(TaskState.fromString(reader.getString()));
                    continue;
                }
                if ("commands".equals(fieldName)) {
                    List commands = reader.readArray(reader1 -> CommandPropertiesInner.fromJson(reader1));
                    deserializedConnectToTargetSqlDbSyncTaskProperties.withCommands(commands);
                    continue;
                }
                if ("clientData".equals(fieldName)) {
                    Map clientData = reader.readMap(reader1 -> reader1.getString());
                    deserializedConnectToTargetSqlDbSyncTaskProperties.withClientData(clientData);
                    continue;
                }
                if ("taskType".equals(fieldName)) {
                    deserializedConnectToTargetSqlDbSyncTaskProperties.taskType = TaskType.fromString(reader.getString());
                    continue;
                }
                if ("input".equals(fieldName)) {
                    deserializedConnectToTargetSqlDbSyncTaskProperties.input = ConnectToTargetSqlDbSyncTaskInput.fromJson(reader);
                    continue;
                }
                if ("output".equals(fieldName)) {
                    List output;
                    deserializedConnectToTargetSqlDbSyncTaskProperties.output = output = reader.readArray(reader1 -> ConnectToTargetSqlDbTaskOutput.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectToTargetSqlDbSyncTaskProperties;
        });
    }
}

