/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.PostgreSqlConnectionInfo;
import java.io.IOException;

public final class ConnectToTargetAzureDbForPostgreSqlSyncTaskInput
implements JsonSerializable<ConnectToTargetAzureDbForPostgreSqlSyncTaskInput> {
    private PostgreSqlConnectionInfo sourceConnectionInfo;
    private PostgreSqlConnectionInfo targetConnectionInfo;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectToTargetAzureDbForPostgreSqlSyncTaskInput.class);

    public PostgreSqlConnectionInfo sourceConnectionInfo() {
        return this.sourceConnectionInfo;
    }

    public ConnectToTargetAzureDbForPostgreSqlSyncTaskInput withSourceConnectionInfo(PostgreSqlConnectionInfo sourceConnectionInfo) {
        this.sourceConnectionInfo = sourceConnectionInfo;
        return this;
    }

    public PostgreSqlConnectionInfo targetConnectionInfo() {
        return this.targetConnectionInfo;
    }

    public ConnectToTargetAzureDbForPostgreSqlSyncTaskInput withTargetConnectionInfo(PostgreSqlConnectionInfo targetConnectionInfo) {
        this.targetConnectionInfo = targetConnectionInfo;
        return this;
    }

    public void validate() {
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model ConnectToTargetAzureDbForPostgreSqlSyncTaskInput"));
        }
        this.sourceConnectionInfo().validate();
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model ConnectToTargetAzureDbForPostgreSqlSyncTaskInput"));
        }
        this.targetConnectionInfo().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo);
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo);
        return jsonWriter.writeEndObject();
    }

    public static ConnectToTargetAzureDbForPostgreSqlSyncTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectToTargetAzureDbForPostgreSqlSyncTaskInput)jsonReader.readObject(reader -> {
            ConnectToTargetAzureDbForPostgreSqlSyncTaskInput deserializedConnectToTargetAzureDbForPostgreSqlSyncTaskInput = new ConnectToTargetAzureDbForPostgreSqlSyncTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedConnectToTargetAzureDbForPostgreSqlSyncTaskInput.sourceConnectionInfo = PostgreSqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedConnectToTargetAzureDbForPostgreSqlSyncTaskInput.targetConnectionInfo = PostgreSqlConnectionInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectToTargetAzureDbForPostgreSqlSyncTaskInput;
        });
    }
}

