/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import com.azure.resourcemanager.datamigration.models.ServerProperties;
import java.io.IOException;
import java.util.List;

public final class ConnectToSourceNonSqlTaskOutput
implements JsonSerializable<ConnectToSourceNonSqlTaskOutput> {
    private String id;
    private String sourceServerBrandVersion;
    private ServerProperties serverProperties;
    private List<String> databases;
    private List<ReportableException> validationErrors;

    public String id() {
        return this.id;
    }

    public String sourceServerBrandVersion() {
        return this.sourceServerBrandVersion;
    }

    public ServerProperties serverProperties() {
        return this.serverProperties;
    }

    public List<String> databases() {
        return this.databases;
    }

    public List<ReportableException> validationErrors() {
        return this.validationErrors;
    }

    public void validate() {
        if (this.serverProperties() != null) {
            this.serverProperties().validate();
        }
        if (this.validationErrors() != null) {
            this.validationErrors().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ConnectToSourceNonSqlTaskOutput fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectToSourceNonSqlTaskOutput)jsonReader.readObject(reader -> {
            ConnectToSourceNonSqlTaskOutput deserializedConnectToSourceNonSqlTaskOutput = new ConnectToSourceNonSqlTaskOutput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedConnectToSourceNonSqlTaskOutput.id = reader.getString();
                    continue;
                }
                if ("sourceServerBrandVersion".equals(fieldName)) {
                    deserializedConnectToSourceNonSqlTaskOutput.sourceServerBrandVersion = reader.getString();
                    continue;
                }
                if ("serverProperties".equals(fieldName)) {
                    deserializedConnectToSourceNonSqlTaskOutput.serverProperties = ServerProperties.fromJson(reader);
                    continue;
                }
                if ("databases".equals(fieldName)) {
                    List databases;
                    deserializedConnectToSourceNonSqlTaskOutput.databases = databases = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("validationErrors".equals(fieldName)) {
                    List validationErrors;
                    deserializedConnectToSourceNonSqlTaskOutput.validationErrors = validationErrors = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectToSourceNonSqlTaskOutput;
        });
    }
}

