/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.ServicesClient;
import com.azure.resourcemanager.datamigration.fluent.models.AvailableServiceSkuInner;
import com.azure.resourcemanager.datamigration.fluent.models.DataMigrationServiceInner;
import com.azure.resourcemanager.datamigration.fluent.models.DataMigrationServiceStatusResponseInner;
import com.azure.resourcemanager.datamigration.fluent.models.NameAvailabilityResponseInner;
import com.azure.resourcemanager.datamigration.implementation.AvailableServiceSkuImpl;
import com.azure.resourcemanager.datamigration.implementation.DataMigrationServiceImpl;
import com.azure.resourcemanager.datamigration.implementation.DataMigrationServiceStatusResponseImpl;
import com.azure.resourcemanager.datamigration.implementation.NameAvailabilityResponseImpl;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.AvailableServiceSku;
import com.azure.resourcemanager.datamigration.models.DataMigrationService;
import com.azure.resourcemanager.datamigration.models.DataMigrationServiceStatusResponse;
import com.azure.resourcemanager.datamigration.models.NameAvailabilityRequest;
import com.azure.resourcemanager.datamigration.models.NameAvailabilityResponse;
import com.azure.resourcemanager.datamigration.models.Services;

public final class ServicesImpl
implements Services {
    private static final ClientLogger LOGGER = new ClientLogger(ServicesImpl.class);
    private final ServicesClient innerClient;
    private final DataMigrationManager serviceManager;

    public ServicesImpl(ServicesClient innerClient, DataMigrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DataMigrationService> getByResourceGroupWithResponse(String groupName, String serviceName, Context context) {
        Response<DataMigrationServiceInner> inner = this.serviceClient().getByResourceGroupWithResponse(groupName, serviceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DataMigrationServiceImpl((DataMigrationServiceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DataMigrationService getByResourceGroup(String groupName, String serviceName) {
        DataMigrationServiceInner inner = this.serviceClient().getByResourceGroup(groupName, serviceName);
        if (inner != null) {
            return new DataMigrationServiceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String groupName, String serviceName) {
        this.serviceClient().delete(groupName, serviceName);
    }

    @Override
    public void delete(String groupName, String serviceName, Boolean deleteRunningTasks, Context context) {
        this.serviceClient().delete(groupName, serviceName, deleteRunningTasks, context);
    }

    @Override
    public Response<DataMigrationServiceStatusResponse> checkStatusWithResponse(String groupName, String serviceName, Context context) {
        Response<DataMigrationServiceStatusResponseInner> inner = this.serviceClient().checkStatusWithResponse(groupName, serviceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DataMigrationServiceStatusResponseImpl((DataMigrationServiceStatusResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DataMigrationServiceStatusResponse checkStatus(String groupName, String serviceName) {
        DataMigrationServiceStatusResponseInner inner = this.serviceClient().checkStatus(groupName, serviceName);
        if (inner != null) {
            return new DataMigrationServiceStatusResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void start(String groupName, String serviceName) {
        this.serviceClient().start(groupName, serviceName);
    }

    @Override
    public void start(String groupName, String serviceName, Context context) {
        this.serviceClient().start(groupName, serviceName, context);
    }

    @Override
    public void stop(String groupName, String serviceName) {
        this.serviceClient().stop(groupName, serviceName);
    }

    @Override
    public void stop(String groupName, String serviceName, Context context) {
        this.serviceClient().stop(groupName, serviceName, context);
    }

    @Override
    public PagedIterable<AvailableServiceSku> listSkus(String groupName, String serviceName) {
        PagedIterable<AvailableServiceSkuInner> inner = this.serviceClient().listSkus(groupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AvailableServiceSkuImpl((AvailableServiceSkuInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<AvailableServiceSku> listSkus(String groupName, String serviceName, Context context) {
        PagedIterable<AvailableServiceSkuInner> inner = this.serviceClient().listSkus(groupName, serviceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AvailableServiceSkuImpl((AvailableServiceSkuInner)inner1, this.manager()));
    }

    @Override
    public Response<NameAvailabilityResponse> checkChildrenNameAvailabilityWithResponse(String groupName, String serviceName, NameAvailabilityRequest parameters, Context context) {
        Response<NameAvailabilityResponseInner> inner = this.serviceClient().checkChildrenNameAvailabilityWithResponse(groupName, serviceName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NameAvailabilityResponseImpl((NameAvailabilityResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public NameAvailabilityResponse checkChildrenNameAvailability(String groupName, String serviceName, NameAvailabilityRequest parameters) {
        NameAvailabilityResponseInner inner = this.serviceClient().checkChildrenNameAvailability(groupName, serviceName, parameters);
        if (inner != null) {
            return new NameAvailabilityResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<DataMigrationService> listByResourceGroup(String groupName) {
        PagedIterable<DataMigrationServiceInner> inner = this.serviceClient().listByResourceGroup(groupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DataMigrationServiceImpl((DataMigrationServiceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DataMigrationService> listByResourceGroup(String groupName, Context context) {
        PagedIterable<DataMigrationServiceInner> inner = this.serviceClient().listByResourceGroup(groupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DataMigrationServiceImpl((DataMigrationServiceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DataMigrationService> list() {
        PagedIterable<DataMigrationServiceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DataMigrationServiceImpl((DataMigrationServiceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DataMigrationService> list(Context context) {
        PagedIterable<DataMigrationServiceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DataMigrationServiceImpl((DataMigrationServiceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<NameAvailabilityResponse> checkNameAvailabilityWithResponse(String location, NameAvailabilityRequest parameters, Context context) {
        Response<NameAvailabilityResponseInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(location, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NameAvailabilityResponseImpl((NameAvailabilityResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public NameAvailabilityResponse checkNameAvailability(String location, NameAvailabilityRequest parameters) {
        NameAvailabilityResponseInner inner = this.serviceClient().checkNameAvailability(location, parameters);
        if (inner != null) {
            return new NameAvailabilityResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DataMigrationService getById(String id) {
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        return (DataMigrationService)this.getByResourceGroupWithResponse(groupName, serviceName, Context.NONE).getValue();
    }

    @Override
    public Response<DataMigrationService> getByIdWithResponse(String id, Context context) {
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        return this.getByResourceGroupWithResponse(groupName, serviceName, context);
    }

    @Override
    public void deleteById(String id) {
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        Boolean localDeleteRunningTasks = null;
        this.delete(groupName, serviceName, localDeleteRunningTasks, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Boolean deleteRunningTasks, Context context) {
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        this.delete(groupName, serviceName, deleteRunningTasks, context);
    }

    private ServicesClient serviceClient() {
        return this.innerClient;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DataMigrationServiceImpl define(String name) {
        return new DataMigrationServiceImpl(name, this.manager());
    }
}

