/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.MigrationServicesClient;
import com.azure.resourcemanager.datamigration.fluent.models.DatabaseMigrationBaseInner;
import com.azure.resourcemanager.datamigration.fluent.models.MigrationServiceInner;
import com.azure.resourcemanager.datamigration.implementation.DatabaseMigrationBaseImpl;
import com.azure.resourcemanager.datamigration.implementation.MigrationServiceImpl;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationBase;
import com.azure.resourcemanager.datamigration.models.MigrationService;
import com.azure.resourcemanager.datamigration.models.MigrationServices;

public final class MigrationServicesImpl
implements MigrationServices {
    private static final ClientLogger LOGGER = new ClientLogger(MigrationServicesImpl.class);
    private final MigrationServicesClient innerClient;
    private final DataMigrationManager serviceManager;

    public MigrationServicesImpl(MigrationServicesClient innerClient, DataMigrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<MigrationService> getByResourceGroupWithResponse(String resourceGroupName, String migrationServiceName, Context context) {
        Response<MigrationServiceInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, migrationServiceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new MigrationServiceImpl((MigrationServiceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public MigrationService getByResourceGroup(String resourceGroupName, String migrationServiceName) {
        MigrationServiceInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, migrationServiceName);
        if (inner != null) {
            return new MigrationServiceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String migrationServiceName) {
        this.serviceClient().delete(resourceGroupName, migrationServiceName);
    }

    @Override
    public void delete(String resourceGroupName, String migrationServiceName, Context context) {
        this.serviceClient().delete(resourceGroupName, migrationServiceName, context);
    }

    @Override
    public PagedIterable<MigrationService> listByResourceGroup(String resourceGroupName) {
        PagedIterable<MigrationServiceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MigrationServiceImpl((MigrationServiceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<MigrationService> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<MigrationServiceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MigrationServiceImpl((MigrationServiceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<MigrationService> list() {
        PagedIterable<MigrationServiceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MigrationServiceImpl((MigrationServiceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<MigrationService> list(Context context) {
        PagedIterable<MigrationServiceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MigrationServiceImpl((MigrationServiceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DatabaseMigrationBase> listMigrations(String resourceGroupName, String migrationServiceName) {
        PagedIterable<DatabaseMigrationBaseInner> inner = this.serviceClient().listMigrations(resourceGroupName, migrationServiceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DatabaseMigrationBaseImpl((DatabaseMigrationBaseInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DatabaseMigrationBase> listMigrations(String resourceGroupName, String migrationServiceName, Context context) {
        PagedIterable<DatabaseMigrationBaseInner> inner = this.serviceClient().listMigrations(resourceGroupName, migrationServiceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DatabaseMigrationBaseImpl((DatabaseMigrationBaseInner)((Object)inner1), this.manager()));
    }

    @Override
    public MigrationService getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String migrationServiceName = ResourceManagerUtils.getValueFromIdByName(id, "migrationServices");
        if (migrationServiceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'migrationServices'.", id)));
        }
        return (MigrationService)this.getByResourceGroupWithResponse(resourceGroupName, migrationServiceName, Context.NONE).getValue();
    }

    @Override
    public Response<MigrationService> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String migrationServiceName = ResourceManagerUtils.getValueFromIdByName(id, "migrationServices");
        if (migrationServiceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'migrationServices'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, migrationServiceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String migrationServiceName = ResourceManagerUtils.getValueFromIdByName(id, "migrationServices");
        if (migrationServiceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'migrationServices'.", id)));
        }
        this.delete(resourceGroupName, migrationServiceName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String migrationServiceName = ResourceManagerUtils.getValueFromIdByName(id, "migrationServices");
        if (migrationServiceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'migrationServices'.", id)));
        }
        this.delete(resourceGroupName, migrationServiceName, context);
    }

    private MigrationServicesClient serviceClient() {
        return this.innerClient;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public MigrationServiceImpl define(String name) {
        return new MigrationServiceImpl(name, this.manager());
    }
}

