/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.datamigration.fluent.FilesClient;
import com.azure.resourcemanager.datamigration.fluent.models.FileStorageInfoInner;
import com.azure.resourcemanager.datamigration.fluent.models.ProjectFileInner;
import com.azure.resourcemanager.datamigration.implementation.DataMigrationManagementClientImpl;
import com.azure.resourcemanager.datamigration.models.FileList;
import reactor.core.publisher.Mono;

public final class FilesClientImpl
implements FilesClient {
    private final FilesService service;
    private final DataMigrationManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(FilesClientImpl.class);

    FilesClientImpl(DataMigrationManagementClientImpl client) {
        this.service = (FilesService)RestProxy.create(FilesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ProjectFileInner>> listSinglePageAsync(String groupName, String serviceName, String projectName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), groupName, serviceName, projectName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileList)res.getValue()).value(), ((FileList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ProjectFileInner> listAsync(String groupName, String serviceName, String projectName) {
        return new PagedFlux(() -> this.listSinglePageAsync(groupName, serviceName, projectName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ProjectFileInner> listSinglePage(String groupName, String serviceName, String projectName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (groupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (serviceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (projectName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<FileList> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), groupName, serviceName, projectName, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileList)res.getValue()).value(), ((FileList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ProjectFileInner> listSinglePage(String groupName, String serviceName, String projectName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (groupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (serviceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (projectName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<FileList> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), groupName, serviceName, projectName, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileList)res.getValue()).value(), ((FileList)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ProjectFileInner> list(String groupName, String serviceName, String projectName) {
        return new PagedIterable(() -> this.listSinglePage(groupName, serviceName, projectName), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ProjectFileInner> list(String groupName, String serviceName, String projectName, Context context) {
        return new PagedIterable(() -> this.listSinglePage(groupName, serviceName, projectName, context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ProjectFileInner>> getWithResponseAsync(String groupName, String serviceName, String projectName, String fileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (fileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fileName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), groupName, serviceName, projectName, fileName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ProjectFileInner> getAsync(String groupName, String serviceName, String projectName, String fileName) {
        return this.getWithResponseAsync(groupName, serviceName, projectName, fileName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ProjectFileInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ProjectFileInner> getWithResponse(String groupName, String serviceName, String projectName, String fileName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (groupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (serviceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (projectName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (fileName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter fileName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), groupName, serviceName, projectName, fileName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ProjectFileInner get(String groupName, String serviceName, String projectName, String fileName) {
        return (ProjectFileInner)((Object)this.getWithResponse(groupName, serviceName, projectName, fileName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ProjectFileInner>> createOrUpdateWithResponseAsync(String groupName, String serviceName, String projectName, String fileName, ProjectFileInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (fileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fileName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), groupName, serviceName, projectName, fileName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ProjectFileInner> createOrUpdateAsync(String groupName, String serviceName, String projectName, String fileName, ProjectFileInner parameters) {
        return this.createOrUpdateWithResponseAsync(groupName, serviceName, projectName, fileName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ProjectFileInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ProjectFileInner> createOrUpdateWithResponse(String groupName, String serviceName, String projectName, String fileName, ProjectFileInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (groupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (serviceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (projectName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (fileName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter fileName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), groupName, serviceName, projectName, fileName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ProjectFileInner createOrUpdate(String groupName, String serviceName, String projectName, String fileName, ProjectFileInner parameters) {
        return (ProjectFileInner)((Object)this.createOrUpdateWithResponse(groupName, serviceName, projectName, fileName, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String groupName, String serviceName, String projectName, String fileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (fileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fileName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), groupName, serviceName, projectName, fileName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String groupName, String serviceName, String projectName, String fileName) {
        return this.deleteWithResponseAsync(groupName, serviceName, projectName, fileName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String groupName, String serviceName, String projectName, String fileName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (groupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (serviceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (projectName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (fileName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter fileName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), groupName, serviceName, projectName, fileName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String groupName, String serviceName, String projectName, String fileName) {
        this.deleteWithResponse(groupName, serviceName, projectName, fileName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ProjectFileInner>> updateWithResponseAsync(String groupName, String serviceName, String projectName, String fileName, ProjectFileInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (fileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fileName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), groupName, serviceName, projectName, fileName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ProjectFileInner> updateAsync(String groupName, String serviceName, String projectName, String fileName, ProjectFileInner parameters) {
        return this.updateWithResponseAsync(groupName, serviceName, projectName, fileName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ProjectFileInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ProjectFileInner> updateWithResponse(String groupName, String serviceName, String projectName, String fileName, ProjectFileInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (groupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (serviceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (projectName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (fileName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter fileName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), groupName, serviceName, projectName, fileName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ProjectFileInner update(String groupName, String serviceName, String projectName, String fileName, ProjectFileInner parameters) {
        return (ProjectFileInner)((Object)this.updateWithResponse(groupName, serviceName, projectName, fileName, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<FileStorageInfoInner>> readWithResponseAsync(String groupName, String serviceName, String projectName, String fileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (fileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fileName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.read(this.client.getEndpoint(), this.client.getSubscriptionId(), groupName, serviceName, projectName, fileName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<FileStorageInfoInner> readAsync(String groupName, String serviceName, String projectName, String fileName) {
        return this.readWithResponseAsync(groupName, serviceName, projectName, fileName).flatMap(res -> Mono.justOrEmpty((Object)((FileStorageInfoInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FileStorageInfoInner> readWithResponse(String groupName, String serviceName, String projectName, String fileName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (groupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (serviceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (projectName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (fileName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter fileName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.readSync(this.client.getEndpoint(), this.client.getSubscriptionId(), groupName, serviceName, projectName, fileName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileStorageInfoInner read(String groupName, String serviceName, String projectName, String fileName) {
        return (FileStorageInfoInner)this.readWithResponse(groupName, serviceName, projectName, fileName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<FileStorageInfoInner>> readWriteWithResponseAsync(String groupName, String serviceName, String projectName, String fileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (fileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fileName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.readWrite(this.client.getEndpoint(), this.client.getSubscriptionId(), groupName, serviceName, projectName, fileName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<FileStorageInfoInner> readWriteAsync(String groupName, String serviceName, String projectName, String fileName) {
        return this.readWriteWithResponseAsync(groupName, serviceName, projectName, fileName).flatMap(res -> Mono.justOrEmpty((Object)((FileStorageInfoInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FileStorageInfoInner> readWriteWithResponse(String groupName, String serviceName, String projectName, String fileName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (groupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (serviceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (projectName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        if (fileName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter fileName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.readWriteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), groupName, serviceName, projectName, fileName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileStorageInfoInner readWrite(String groupName, String serviceName, String projectName, String fileName) {
        return (FileStorageInfoInner)this.readWriteWithResponse(groupName, serviceName, projectName, fileName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ProjectFileInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileList)res.getValue()).value(), ((FileList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ProjectFileInner> listNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<FileList> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileList)res.getValue()).value(), ((FileList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ProjectFileInner> listNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<FileList> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileList)res.getValue()).value(), ((FileList)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataMigrationManagementClientFiles")
    public static interface FilesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FileList>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="groupName") String var3, @PathParam(value="serviceName") String var4, @PathParam(value="projectName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<FileList> listSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="groupName") String var3, @PathParam(value="serviceName") String var4, @PathParam(value="projectName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ProjectFileInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="groupName") String var3, @PathParam(value="serviceName") String var4, @PathParam(value="projectName") String var5, @PathParam(value="fileName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ProjectFileInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="groupName") String var3, @PathParam(value="serviceName") String var4, @PathParam(value="projectName") String var5, @PathParam(value="fileName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ProjectFileInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="groupName") String var3, @PathParam(value="serviceName") String var4, @PathParam(value="projectName") String var5, @PathParam(value="fileName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") ProjectFileInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ProjectFileInner> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="groupName") String var3, @PathParam(value="serviceName") String var4, @PathParam(value="projectName") String var5, @PathParam(value="fileName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") ProjectFileInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="groupName") String var3, @PathParam(value="serviceName") String var4, @PathParam(value="projectName") String var5, @PathParam(value="fileName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<Void> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="groupName") String var3, @PathParam(value="serviceName") String var4, @PathParam(value="projectName") String var5, @PathParam(value="fileName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ProjectFileInner>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="groupName") String var3, @PathParam(value="serviceName") String var4, @PathParam(value="projectName") String var5, @PathParam(value="fileName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") ProjectFileInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ProjectFileInner> updateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="groupName") String var3, @PathParam(value="serviceName") String var4, @PathParam(value="projectName") String var5, @PathParam(value="fileName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") ProjectFileInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}/read")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FileStorageInfoInner>> read(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="groupName") String var3, @PathParam(value="serviceName") String var4, @PathParam(value="projectName") String var5, @PathParam(value="fileName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}/read")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<FileStorageInfoInner> readSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="groupName") String var3, @PathParam(value="serviceName") String var4, @PathParam(value="projectName") String var5, @PathParam(value="fileName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}/readwrite")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FileStorageInfoInner>> readWrite(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="groupName") String var3, @PathParam(value="serviceName") String var4, @PathParam(value="projectName") String var5, @PathParam(value="fileName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}/readwrite")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<FileStorageInfoInner> readWriteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="groupName") String var3, @PathParam(value="serviceName") String var4, @PathParam(value="projectName") String var5, @PathParam(value="fileName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FileList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<FileList> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

