/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.DatabaseMigrationsMongoToCosmosDbRUMongoesClient;
import com.azure.resourcemanager.datamigration.fluent.models.DatabaseMigrationCosmosDbMongoInner;
import com.azure.resourcemanager.datamigration.implementation.DatabaseMigrationCosmosDbMongoImpl;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationCosmosDbMongo;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationsMongoToCosmosDbRUMongoes;

public final class DatabaseMigrationsMongoToCosmosDbRUMongoesImpl
implements DatabaseMigrationsMongoToCosmosDbRUMongoes {
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseMigrationsMongoToCosmosDbRUMongoesImpl.class);
    private final DatabaseMigrationsMongoToCosmosDbRUMongoesClient innerClient;
    private final DataMigrationManager serviceManager;

    public DatabaseMigrationsMongoToCosmosDbRUMongoesImpl(DatabaseMigrationsMongoToCosmosDbRUMongoesClient innerClient, DataMigrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DatabaseMigrationCosmosDbMongo> getWithResponse(String resourceGroupName, String targetResourceName, String migrationName, Context context) {
        Response<DatabaseMigrationCosmosDbMongoInner> inner = this.serviceClient().getWithResponse(resourceGroupName, targetResourceName, migrationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DatabaseMigrationCosmosDbMongoImpl((DatabaseMigrationCosmosDbMongoInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DatabaseMigrationCosmosDbMongo get(String resourceGroupName, String targetResourceName, String migrationName) {
        DatabaseMigrationCosmosDbMongoInner inner = this.serviceClient().get(resourceGroupName, targetResourceName, migrationName);
        if (inner != null) {
            return new DatabaseMigrationCosmosDbMongoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String targetResourceName, String migrationName) {
        this.serviceClient().delete(resourceGroupName, targetResourceName, migrationName);
    }

    @Override
    public void delete(String resourceGroupName, String targetResourceName, String migrationName, Boolean force, Context context) {
        this.serviceClient().delete(resourceGroupName, targetResourceName, migrationName, force, context);
    }

    @Override
    public PagedIterable<DatabaseMigrationCosmosDbMongo> getForScope(String resourceGroupName, String targetResourceName) {
        PagedIterable<DatabaseMigrationCosmosDbMongoInner> inner = this.serviceClient().getForScope(resourceGroupName, targetResourceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DatabaseMigrationCosmosDbMongoImpl((DatabaseMigrationCosmosDbMongoInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DatabaseMigrationCosmosDbMongo> getForScope(String resourceGroupName, String targetResourceName, Context context) {
        PagedIterable<DatabaseMigrationCosmosDbMongoInner> inner = this.serviceClient().getForScope(resourceGroupName, targetResourceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DatabaseMigrationCosmosDbMongoImpl((DatabaseMigrationCosmosDbMongoInner)((Object)inner1), this.manager()));
    }

    @Override
    public DatabaseMigrationCosmosDbMongo getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetResourceName = ResourceManagerUtils.getValueFromIdByName(id, "databaseAccounts");
        if (targetResourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseAccounts'.", id)));
        }
        String migrationName = ResourceManagerUtils.getValueFromIdByName(id, "databaseMigrations");
        if (migrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseMigrations'.", id)));
        }
        return (DatabaseMigrationCosmosDbMongo)this.getWithResponse(resourceGroupName, targetResourceName, migrationName, Context.NONE).getValue();
    }

    @Override
    public Response<DatabaseMigrationCosmosDbMongo> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetResourceName = ResourceManagerUtils.getValueFromIdByName(id, "databaseAccounts");
        if (targetResourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseAccounts'.", id)));
        }
        String migrationName = ResourceManagerUtils.getValueFromIdByName(id, "databaseMigrations");
        if (migrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseMigrations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, targetResourceName, migrationName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetResourceName = ResourceManagerUtils.getValueFromIdByName(id, "databaseAccounts");
        if (targetResourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseAccounts'.", id)));
        }
        String migrationName = ResourceManagerUtils.getValueFromIdByName(id, "databaseMigrations");
        if (migrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseMigrations'.", id)));
        }
        Boolean localForce = null;
        this.delete(resourceGroupName, targetResourceName, migrationName, localForce, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Boolean force, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetResourceName = ResourceManagerUtils.getValueFromIdByName(id, "databaseAccounts");
        if (targetResourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseAccounts'.", id)));
        }
        String migrationName = ResourceManagerUtils.getValueFromIdByName(id, "databaseMigrations");
        if (migrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseMigrations'.", id)));
        }
        this.delete(resourceGroupName, targetResourceName, migrationName, force, context);
    }

    private DatabaseMigrationsMongoToCosmosDbRUMongoesClient serviceClient() {
        return this.innerClient;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DatabaseMigrationCosmosDbMongoImpl define(String name) {
        return new DatabaseMigrationCosmosDbMongoImpl(name, this.manager());
    }
}

