/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.management.polling.SyncPollerFactory;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.datamigration.fluent.DataMigrationManagementClient;
import com.azure.resourcemanager.datamigration.fluent.DatabaseMigrationsMongoToCosmosDbRUMongoesClient;
import com.azure.resourcemanager.datamigration.fluent.DatabaseMigrationsMongoToCosmosDbvCoreMongoesClient;
import com.azure.resourcemanager.datamigration.fluent.DatabaseMigrationsSqlDbsClient;
import com.azure.resourcemanager.datamigration.fluent.DatabaseMigrationsSqlMisClient;
import com.azure.resourcemanager.datamigration.fluent.DatabaseMigrationsSqlVmsClient;
import com.azure.resourcemanager.datamigration.fluent.FilesClient;
import com.azure.resourcemanager.datamigration.fluent.MigrationServicesClient;
import com.azure.resourcemanager.datamigration.fluent.OperationsClient;
import com.azure.resourcemanager.datamigration.fluent.ProjectsClient;
import com.azure.resourcemanager.datamigration.fluent.ResourceSkusClient;
import com.azure.resourcemanager.datamigration.fluent.ServiceTasksClient;
import com.azure.resourcemanager.datamigration.fluent.ServicesClient;
import com.azure.resourcemanager.datamigration.fluent.SqlMigrationServicesClient;
import com.azure.resourcemanager.datamigration.fluent.TasksClient;
import com.azure.resourcemanager.datamigration.fluent.UsagesClient;
import com.azure.resourcemanager.datamigration.implementation.DataMigrationManagementClientBuilder;
import com.azure.resourcemanager.datamigration.implementation.DatabaseMigrationsMongoToCosmosDbRUMongoesClientImpl;
import com.azure.resourcemanager.datamigration.implementation.DatabaseMigrationsMongoToCosmosDbvCoreMongoesClientImpl;
import com.azure.resourcemanager.datamigration.implementation.DatabaseMigrationsSqlDbsClientImpl;
import com.azure.resourcemanager.datamigration.implementation.DatabaseMigrationsSqlMisClientImpl;
import com.azure.resourcemanager.datamigration.implementation.DatabaseMigrationsSqlVmsClientImpl;
import com.azure.resourcemanager.datamigration.implementation.FilesClientImpl;
import com.azure.resourcemanager.datamigration.implementation.MigrationServicesClientImpl;
import com.azure.resourcemanager.datamigration.implementation.OperationsClientImpl;
import com.azure.resourcemanager.datamigration.implementation.ProjectsClientImpl;
import com.azure.resourcemanager.datamigration.implementation.ResourceSkusClientImpl;
import com.azure.resourcemanager.datamigration.implementation.ServiceTasksClientImpl;
import com.azure.resourcemanager.datamigration.implementation.ServicesClientImpl;
import com.azure.resourcemanager.datamigration.implementation.SqlMigrationServicesClientImpl;
import com.azure.resourcemanager.datamigration.implementation.TasksClientImpl;
import com.azure.resourcemanager.datamigration.implementation.UsagesClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DataMigrationManagementClientBuilder.class)
public final class DataMigrationManagementClientImpl
implements DataMigrationManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final DatabaseMigrationsMongoToCosmosDbRUMongoesClient databaseMigrationsMongoToCosmosDbRUMongoes;
    private final DatabaseMigrationsMongoToCosmosDbvCoreMongoesClient databaseMigrationsMongoToCosmosDbvCoreMongoes;
    private final DatabaseMigrationsSqlDbsClient databaseMigrationsSqlDbs;
    private final DatabaseMigrationsSqlMisClient databaseMigrationsSqlMis;
    private final DatabaseMigrationsSqlVmsClient databaseMigrationsSqlVms;
    private final OperationsClient operations;
    private final MigrationServicesClient migrationServices;
    private final SqlMigrationServicesClient sqlMigrationServices;
    private final ResourceSkusClient resourceSkus;
    private final ServicesClient services;
    private final TasksClient tasks;
    private final ServiceTasksClient serviceTasks;
    private final ProjectsClient projects;
    private final UsagesClient usages;
    private final FilesClient files;
    private static final ClientLogger LOGGER = new ClientLogger(DataMigrationManagementClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public DatabaseMigrationsMongoToCosmosDbRUMongoesClient getDatabaseMigrationsMongoToCosmosDbRUMongoes() {
        return this.databaseMigrationsMongoToCosmosDbRUMongoes;
    }

    @Override
    public DatabaseMigrationsMongoToCosmosDbvCoreMongoesClient getDatabaseMigrationsMongoToCosmosDbvCoreMongoes() {
        return this.databaseMigrationsMongoToCosmosDbvCoreMongoes;
    }

    @Override
    public DatabaseMigrationsSqlDbsClient getDatabaseMigrationsSqlDbs() {
        return this.databaseMigrationsSqlDbs;
    }

    @Override
    public DatabaseMigrationsSqlMisClient getDatabaseMigrationsSqlMis() {
        return this.databaseMigrationsSqlMis;
    }

    @Override
    public DatabaseMigrationsSqlVmsClient getDatabaseMigrationsSqlVms() {
        return this.databaseMigrationsSqlVms;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public MigrationServicesClient getMigrationServices() {
        return this.migrationServices;
    }

    @Override
    public SqlMigrationServicesClient getSqlMigrationServices() {
        return this.sqlMigrationServices;
    }

    @Override
    public ResourceSkusClient getResourceSkus() {
        return this.resourceSkus;
    }

    @Override
    public ServicesClient getServices() {
        return this.services;
    }

    @Override
    public TasksClient getTasks() {
        return this.tasks;
    }

    @Override
    public ServiceTasksClient getServiceTasks() {
        return this.serviceTasks;
    }

    @Override
    public ProjectsClient getProjects() {
        return this.projects;
    }

    @Override
    public UsagesClient getUsages() {
        return this.usages;
    }

    @Override
    public FilesClient getFiles() {
        return this.files;
    }

    DataMigrationManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2025-06-30";
        this.databaseMigrationsMongoToCosmosDbRUMongoes = new DatabaseMigrationsMongoToCosmosDbRUMongoesClientImpl(this);
        this.databaseMigrationsMongoToCosmosDbvCoreMongoes = new DatabaseMigrationsMongoToCosmosDbvCoreMongoesClientImpl(this);
        this.databaseMigrationsSqlDbs = new DatabaseMigrationsSqlDbsClientImpl(this);
        this.databaseMigrationsSqlMis = new DatabaseMigrationsSqlMisClientImpl(this);
        this.databaseMigrationsSqlVms = new DatabaseMigrationsSqlVmsClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.migrationServices = new MigrationServicesClientImpl(this);
        this.sqlMigrationServices = new SqlMigrationServicesClientImpl(this);
        this.resourceSkus = new ResourceSkusClientImpl(this);
        this.services = new ServicesClientImpl(this);
        this.tasks = new TasksClientImpl(this);
        this.serviceTasks = new ServiceTasksClientImpl(this);
        this.projects = new ProjectsClientImpl(this);
        this.usages = new UsagesClientImpl(this);
        this.files = new FilesClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> SyncPoller<PollResult<T>, U> getLroResult(Response<BinaryData> activationResponse, Type pollResultType, Type finalResultType, Context context) {
        return SyncPollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)this.httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, () -> activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

