/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.ResourceSkuCapabilities;
import com.azure.resourcemanager.datamigration.models.ResourceSkuCapacity;
import com.azure.resourcemanager.datamigration.models.ResourceSkuCosts;
import com.azure.resourcemanager.datamigration.models.ResourceSkuRestrictions;
import java.io.IOException;
import java.util.List;

public final class ResourceSkuInner
implements JsonSerializable<ResourceSkuInner> {
    private String resourceType;
    private String name;
    private String tier;
    private String size;
    private String family;
    private String kind;
    private ResourceSkuCapacity capacity;
    private List<String> locations;
    private List<String> apiVersions;
    private List<ResourceSkuCosts> costs;
    private List<ResourceSkuCapabilities> capabilities;
    private List<ResourceSkuRestrictions> restrictions;

    public String resourceType() {
        return this.resourceType;
    }

    public String name() {
        return this.name;
    }

    public String tier() {
        return this.tier;
    }

    public String size() {
        return this.size;
    }

    public String family() {
        return this.family;
    }

    public String kind() {
        return this.kind;
    }

    public ResourceSkuCapacity capacity() {
        return this.capacity;
    }

    public List<String> locations() {
        return this.locations;
    }

    public List<String> apiVersions() {
        return this.apiVersions;
    }

    public List<ResourceSkuCosts> costs() {
        return this.costs;
    }

    public List<ResourceSkuCapabilities> capabilities() {
        return this.capabilities;
    }

    public List<ResourceSkuRestrictions> restrictions() {
        return this.restrictions;
    }

    public void validate() {
        if (this.capacity() != null) {
            this.capacity().validate();
        }
        if (this.costs() != null) {
            this.costs().forEach(e -> e.validate());
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
        if (this.restrictions() != null) {
            this.restrictions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ResourceSkuInner fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceSkuInner)jsonReader.readObject(reader -> {
            ResourceSkuInner deserializedResourceSkuInner = new ResourceSkuInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceType".equals(fieldName)) {
                    deserializedResourceSkuInner.resourceType = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedResourceSkuInner.name = reader.getString();
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedResourceSkuInner.tier = reader.getString();
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedResourceSkuInner.size = reader.getString();
                    continue;
                }
                if ("family".equals(fieldName)) {
                    deserializedResourceSkuInner.family = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedResourceSkuInner.kind = reader.getString();
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedResourceSkuInner.capacity = ResourceSkuCapacity.fromJson(reader);
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedResourceSkuInner.locations = locations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("apiVersions".equals(fieldName)) {
                    List apiVersions;
                    deserializedResourceSkuInner.apiVersions = apiVersions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("costs".equals(fieldName)) {
                    List costs;
                    deserializedResourceSkuInner.costs = costs = reader.readArray(reader1 -> ResourceSkuCosts.fromJson(reader1));
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List capabilities;
                    deserializedResourceSkuInner.capabilities = capabilities = reader.readArray(reader1 -> ResourceSkuCapabilities.fromJson(reader1));
                    continue;
                }
                if ("restrictions".equals(fieldName)) {
                    List restrictions;
                    deserializedResourceSkuInner.restrictions = restrictions = reader.readArray(reader1 -> ResourceSkuRestrictions.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceSkuInner;
        });
    }
}

