/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.ServiceProvisioningState;
import java.io.IOException;

public final class DataMigrationServiceProperties
implements JsonSerializable<DataMigrationServiceProperties> {
    private ServiceProvisioningState provisioningState;
    private String publicKey;
    private String virtualSubnetId;
    private String virtualNicId;
    private String autoStopDelay;
    private Boolean deleteResourcesOnStop;

    public ServiceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String publicKey() {
        return this.publicKey;
    }

    public DataMigrationServiceProperties withPublicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public String virtualSubnetId() {
        return this.virtualSubnetId;
    }

    public DataMigrationServiceProperties withVirtualSubnetId(String virtualSubnetId) {
        this.virtualSubnetId = virtualSubnetId;
        return this;
    }

    public String virtualNicId() {
        return this.virtualNicId;
    }

    public DataMigrationServiceProperties withVirtualNicId(String virtualNicId) {
        this.virtualNicId = virtualNicId;
        return this;
    }

    public String autoStopDelay() {
        return this.autoStopDelay;
    }

    public DataMigrationServiceProperties withAutoStopDelay(String autoStopDelay) {
        this.autoStopDelay = autoStopDelay;
        return this;
    }

    public Boolean deleteResourcesOnStop() {
        return this.deleteResourcesOnStop;
    }

    public DataMigrationServiceProperties withDeleteResourcesOnStop(Boolean deleteResourcesOnStop) {
        this.deleteResourcesOnStop = deleteResourcesOnStop;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publicKey", this.publicKey);
        jsonWriter.writeStringField("virtualSubnetId", this.virtualSubnetId);
        jsonWriter.writeStringField("virtualNicId", this.virtualNicId);
        jsonWriter.writeStringField("autoStopDelay", this.autoStopDelay);
        jsonWriter.writeBooleanField("deleteResourcesOnStop", this.deleteResourcesOnStop);
        return jsonWriter.writeEndObject();
    }

    public static DataMigrationServiceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DataMigrationServiceProperties)jsonReader.readObject(reader -> {
            DataMigrationServiceProperties deserializedDataMigrationServiceProperties = new DataMigrationServiceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedDataMigrationServiceProperties.provisioningState = ServiceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("publicKey".equals(fieldName)) {
                    deserializedDataMigrationServiceProperties.publicKey = reader.getString();
                    continue;
                }
                if ("virtualSubnetId".equals(fieldName)) {
                    deserializedDataMigrationServiceProperties.virtualSubnetId = reader.getString();
                    continue;
                }
                if ("virtualNicId".equals(fieldName)) {
                    deserializedDataMigrationServiceProperties.virtualNicId = reader.getString();
                    continue;
                }
                if ("autoStopDelay".equals(fieldName)) {
                    deserializedDataMigrationServiceProperties.autoStopDelay = reader.getString();
                    continue;
                }
                if ("deleteResourcesOnStop".equals(fieldName)) {
                    deserializedDataMigrationServiceProperties.deleteResourcesOnStop = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataMigrationServiceProperties;
        });
    }
}

