/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.AvailableServiceSkuCapacity;
import com.azure.resourcemanager.datamigration.models.AvailableServiceSkuSku;
import java.io.IOException;

public final class AvailableServiceSkuInner
implements JsonSerializable<AvailableServiceSkuInner> {
    private String resourceType;
    private AvailableServiceSkuSku sku;
    private AvailableServiceSkuCapacity capacity;

    public String resourceType() {
        return this.resourceType;
    }

    public AvailableServiceSkuInner withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public AvailableServiceSkuSku sku() {
        return this.sku;
    }

    public AvailableServiceSkuInner withSku(AvailableServiceSkuSku sku) {
        this.sku = sku;
        return this;
    }

    public AvailableServiceSkuCapacity capacity() {
        return this.capacity;
    }

    public AvailableServiceSkuInner withCapacity(AvailableServiceSkuCapacity capacity) {
        this.capacity = capacity;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.capacity() != null) {
            this.capacity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceType", this.resourceType);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("capacity", (JsonSerializable)this.capacity);
        return jsonWriter.writeEndObject();
    }

    public static AvailableServiceSkuInner fromJson(JsonReader jsonReader) throws IOException {
        return (AvailableServiceSkuInner)jsonReader.readObject(reader -> {
            AvailableServiceSkuInner deserializedAvailableServiceSkuInner = new AvailableServiceSkuInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceType".equals(fieldName)) {
                    deserializedAvailableServiceSkuInner.resourceType = reader.getString();
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedAvailableServiceSkuInner.sku = AvailableServiceSkuSku.fromJson(reader);
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedAvailableServiceSkuInner.capacity = AvailableServiceSkuCapacity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAvailableServiceSkuInner;
        });
    }
}

