/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datamigration.fluent.DataMigrationManagementClient;
import com.azure.resourcemanager.datamigration.implementation.DataMigrationManagementClientBuilder;
import com.azure.resourcemanager.datamigration.implementation.DatabaseMigrationsMongoToCosmosDbRUMongoesImpl;
import com.azure.resourcemanager.datamigration.implementation.DatabaseMigrationsMongoToCosmosDbvCoreMongoesImpl;
import com.azure.resourcemanager.datamigration.implementation.DatabaseMigrationsSqlDbsImpl;
import com.azure.resourcemanager.datamigration.implementation.DatabaseMigrationsSqlMisImpl;
import com.azure.resourcemanager.datamigration.implementation.DatabaseMigrationsSqlVmsImpl;
import com.azure.resourcemanager.datamigration.implementation.FilesImpl;
import com.azure.resourcemanager.datamigration.implementation.MigrationServicesImpl;
import com.azure.resourcemanager.datamigration.implementation.OperationsImpl;
import com.azure.resourcemanager.datamigration.implementation.ProjectsImpl;
import com.azure.resourcemanager.datamigration.implementation.ResourceSkusImpl;
import com.azure.resourcemanager.datamigration.implementation.ServiceTasksImpl;
import com.azure.resourcemanager.datamigration.implementation.ServicesImpl;
import com.azure.resourcemanager.datamigration.implementation.SqlMigrationServicesImpl;
import com.azure.resourcemanager.datamigration.implementation.TasksImpl;
import com.azure.resourcemanager.datamigration.implementation.UsagesImpl;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationsMongoToCosmosDbRUMongoes;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationsMongoToCosmosDbvCoreMongoes;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationsSqlDbs;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationsSqlMis;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationsSqlVms;
import com.azure.resourcemanager.datamigration.models.Files;
import com.azure.resourcemanager.datamigration.models.MigrationServices;
import com.azure.resourcemanager.datamigration.models.Operations;
import com.azure.resourcemanager.datamigration.models.Projects;
import com.azure.resourcemanager.datamigration.models.ResourceSkus;
import com.azure.resourcemanager.datamigration.models.ServiceTasks;
import com.azure.resourcemanager.datamigration.models.Services;
import com.azure.resourcemanager.datamigration.models.SqlMigrationServices;
import com.azure.resourcemanager.datamigration.models.Tasks;
import com.azure.resourcemanager.datamigration.models.Usages;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class DataMigrationManager {
    private DatabaseMigrationsMongoToCosmosDbRUMongoes databaseMigrationsMongoToCosmosDbRUMongoes;
    private DatabaseMigrationsMongoToCosmosDbvCoreMongoes databaseMigrationsMongoToCosmosDbvCoreMongoes;
    private DatabaseMigrationsSqlDbs databaseMigrationsSqlDbs;
    private DatabaseMigrationsSqlMis databaseMigrationsSqlMis;
    private DatabaseMigrationsSqlVms databaseMigrationsSqlVms;
    private Operations operations;
    private MigrationServices migrationServices;
    private SqlMigrationServices sqlMigrationServices;
    private ResourceSkus resourceSkus;
    private Services services;
    private Tasks tasks;
    private ServiceTasks serviceTasks;
    private Projects projects;
    private Usages usages;
    private Files files;
    private final DataMigrationManagementClient clientObject;

    private DataMigrationManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new DataMigrationManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static DataMigrationManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return DataMigrationManager.configure().authenticate(credential, profile);
    }

    public static DataMigrationManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new DataMigrationManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public DatabaseMigrationsMongoToCosmosDbRUMongoes databaseMigrationsMongoToCosmosDbRUMongoes() {
        if (this.databaseMigrationsMongoToCosmosDbRUMongoes == null) {
            this.databaseMigrationsMongoToCosmosDbRUMongoes = new DatabaseMigrationsMongoToCosmosDbRUMongoesImpl(this.clientObject.getDatabaseMigrationsMongoToCosmosDbRUMongoes(), this);
        }
        return this.databaseMigrationsMongoToCosmosDbRUMongoes;
    }

    public DatabaseMigrationsMongoToCosmosDbvCoreMongoes databaseMigrationsMongoToCosmosDbvCoreMongoes() {
        if (this.databaseMigrationsMongoToCosmosDbvCoreMongoes == null) {
            this.databaseMigrationsMongoToCosmosDbvCoreMongoes = new DatabaseMigrationsMongoToCosmosDbvCoreMongoesImpl(this.clientObject.getDatabaseMigrationsMongoToCosmosDbvCoreMongoes(), this);
        }
        return this.databaseMigrationsMongoToCosmosDbvCoreMongoes;
    }

    public DatabaseMigrationsSqlDbs databaseMigrationsSqlDbs() {
        if (this.databaseMigrationsSqlDbs == null) {
            this.databaseMigrationsSqlDbs = new DatabaseMigrationsSqlDbsImpl(this.clientObject.getDatabaseMigrationsSqlDbs(), this);
        }
        return this.databaseMigrationsSqlDbs;
    }

    public DatabaseMigrationsSqlMis databaseMigrationsSqlMis() {
        if (this.databaseMigrationsSqlMis == null) {
            this.databaseMigrationsSqlMis = new DatabaseMigrationsSqlMisImpl(this.clientObject.getDatabaseMigrationsSqlMis(), this);
        }
        return this.databaseMigrationsSqlMis;
    }

    public DatabaseMigrationsSqlVms databaseMigrationsSqlVms() {
        if (this.databaseMigrationsSqlVms == null) {
            this.databaseMigrationsSqlVms = new DatabaseMigrationsSqlVmsImpl(this.clientObject.getDatabaseMigrationsSqlVms(), this);
        }
        return this.databaseMigrationsSqlVms;
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public MigrationServices migrationServices() {
        if (this.migrationServices == null) {
            this.migrationServices = new MigrationServicesImpl(this.clientObject.getMigrationServices(), this);
        }
        return this.migrationServices;
    }

    public SqlMigrationServices sqlMigrationServices() {
        if (this.sqlMigrationServices == null) {
            this.sqlMigrationServices = new SqlMigrationServicesImpl(this.clientObject.getSqlMigrationServices(), this);
        }
        return this.sqlMigrationServices;
    }

    public ResourceSkus resourceSkus() {
        if (this.resourceSkus == null) {
            this.resourceSkus = new ResourceSkusImpl(this.clientObject.getResourceSkus(), this);
        }
        return this.resourceSkus;
    }

    public Services services() {
        if (this.services == null) {
            this.services = new ServicesImpl(this.clientObject.getServices(), this);
        }
        return this.services;
    }

    public Tasks tasks() {
        if (this.tasks == null) {
            this.tasks = new TasksImpl(this.clientObject.getTasks(), this);
        }
        return this.tasks;
    }

    public ServiceTasks serviceTasks() {
        if (this.serviceTasks == null) {
            this.serviceTasks = new ServiceTasksImpl(this.clientObject.getServiceTasks(), this);
        }
        return this.serviceTasks;
    }

    public Projects projects() {
        if (this.projects == null) {
            this.projects = new ProjectsImpl(this.clientObject.getProjects(), this);
        }
        return this.projects;
    }

    public Usages usages() {
        if (this.usages == null) {
            this.usages = new UsagesImpl(this.clientObject.getUsages(), this);
        }
        return this.usages;
    }

    public Files files() {
        if (this.files == null) {
            this.files = new FilesImpl(this.clientObject.getFiles(), this);
        }
        return this.files;
    }

    public DataMigrationManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private static final String SDK_VERSION = "version";
        private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-resourcemanager-datamigration.properties");
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public DataMigrationManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.datamigration").append("/").append(clientVersion);
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new DataMigrationManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

