/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DependencyReference;
import com.azure.resourcemanager.datafactory.models.TriggerReference;
import com.azure.resourcemanager.datafactory.models.TumblingWindowTriggerDependencyReference;
import java.io.IOException;

public class TriggerDependencyReference
extends DependencyReference {
    private String type = "TriggerDependencyReference";
    private TriggerReference referenceTrigger;
    private static final ClientLogger LOGGER = new ClientLogger(TriggerDependencyReference.class);

    @Override
    public String type() {
        return this.type;
    }

    public TriggerReference referenceTrigger() {
        return this.referenceTrigger;
    }

    public TriggerDependencyReference withReferenceTrigger(TriggerReference referenceTrigger) {
        this.referenceTrigger = referenceTrigger;
        return this;
    }

    @Override
    public void validate() {
        if (this.referenceTrigger() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property referenceTrigger in model TriggerDependencyReference"));
        }
        this.referenceTrigger().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("referenceTrigger", (JsonSerializable)this.referenceTrigger);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static TriggerDependencyReference fromJson(JsonReader jsonReader) throws IOException {
        return (TriggerDependencyReference)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                TriggerDependencyReference triggerDependencyReference;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("TumblingWindowTriggerDependencyReference".equals(discriminatorValue)) {
                    triggerDependencyReference = TumblingWindowTriggerDependencyReference.fromJson(readerToUse.reset());
                    return triggerDependencyReference;
                }
                triggerDependencyReference = TriggerDependencyReference.fromJsonKnownDiscriminator(readerToUse.reset());
                return triggerDependencyReference;
            }
        });
    }

    static TriggerDependencyReference fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (TriggerDependencyReference)jsonReader.readObject(reader -> {
            TriggerDependencyReference deserializedTriggerDependencyReference = new TriggerDependencyReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("referenceTrigger".equals(fieldName)) {
                    deserializedTriggerDependencyReference.referenceTrigger = TriggerReference.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTriggerDependencyReference.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTriggerDependencyReference;
        });
    }
}

