/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopyTranslator;
import com.azure.resourcemanager.datafactory.models.TypeConversionSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class TabularTranslator
extends CopyTranslator {
    private String type = "TabularTranslator";
    private Object columnMappings;
    private Object schemaMapping;
    private Object collectionReference;
    private Object mapComplexValuesToString;
    private Object mappings;
    private Object typeConversion;
    private TypeConversionSettings typeConversionSettings;

    @Override
    public String type() {
        return this.type;
    }

    public Object columnMappings() {
        return this.columnMappings;
    }

    public TabularTranslator withColumnMappings(Object columnMappings) {
        this.columnMappings = columnMappings;
        return this;
    }

    public Object schemaMapping() {
        return this.schemaMapping;
    }

    public TabularTranslator withSchemaMapping(Object schemaMapping) {
        this.schemaMapping = schemaMapping;
        return this;
    }

    public Object collectionReference() {
        return this.collectionReference;
    }

    public TabularTranslator withCollectionReference(Object collectionReference) {
        this.collectionReference = collectionReference;
        return this;
    }

    public Object mapComplexValuesToString() {
        return this.mapComplexValuesToString;
    }

    public TabularTranslator withMapComplexValuesToString(Object mapComplexValuesToString) {
        this.mapComplexValuesToString = mapComplexValuesToString;
        return this;
    }

    public Object mappings() {
        return this.mappings;
    }

    public TabularTranslator withMappings(Object mappings) {
        this.mappings = mappings;
        return this;
    }

    public Object typeConversion() {
        return this.typeConversion;
    }

    public TabularTranslator withTypeConversion(Object typeConversion) {
        this.typeConversion = typeConversion;
        return this;
    }

    public TypeConversionSettings typeConversionSettings() {
        return this.typeConversionSettings;
    }

    public TabularTranslator withTypeConversionSettings(TypeConversionSettings typeConversionSettings) {
        this.typeConversionSettings = typeConversionSettings;
        return this;
    }

    @Override
    public void validate() {
        if (this.typeConversionSettings() != null) {
            this.typeConversionSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        if (this.columnMappings != null) {
            jsonWriter.writeUntypedField("columnMappings", this.columnMappings);
        }
        if (this.schemaMapping != null) {
            jsonWriter.writeUntypedField("schemaMapping", this.schemaMapping);
        }
        if (this.collectionReference != null) {
            jsonWriter.writeUntypedField("collectionReference", this.collectionReference);
        }
        if (this.mapComplexValuesToString != null) {
            jsonWriter.writeUntypedField("mapComplexValuesToString", this.mapComplexValuesToString);
        }
        if (this.mappings != null) {
            jsonWriter.writeUntypedField("mappings", this.mappings);
        }
        if (this.typeConversion != null) {
            jsonWriter.writeUntypedField("typeConversion", this.typeConversion);
        }
        jsonWriter.writeJsonField("typeConversionSettings", (JsonSerializable)this.typeConversionSettings);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static TabularTranslator fromJson(JsonReader jsonReader) throws IOException {
        return (TabularTranslator)jsonReader.readObject(reader -> {
            TabularTranslator deserializedTabularTranslator = new TabularTranslator();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedTabularTranslator.type = reader.getString();
                    continue;
                }
                if ("columnMappings".equals(fieldName)) {
                    deserializedTabularTranslator.columnMappings = reader.readUntyped();
                    continue;
                }
                if ("schemaMapping".equals(fieldName)) {
                    deserializedTabularTranslator.schemaMapping = reader.readUntyped();
                    continue;
                }
                if ("collectionReference".equals(fieldName)) {
                    deserializedTabularTranslator.collectionReference = reader.readUntyped();
                    continue;
                }
                if ("mapComplexValuesToString".equals(fieldName)) {
                    deserializedTabularTranslator.mapComplexValuesToString = reader.readUntyped();
                    continue;
                }
                if ("mappings".equals(fieldName)) {
                    deserializedTabularTranslator.mappings = reader.readUntyped();
                    continue;
                }
                if ("typeConversion".equals(fieldName)) {
                    deserializedTabularTranslator.typeConversion = reader.readUntyped();
                    continue;
                }
                if ("typeConversionSettings".equals(fieldName)) {
                    deserializedTabularTranslator.typeConversionSettings = TypeConversionSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedTabularTranslator.withAdditionalProperties(additionalProperties);
            return deserializedTabularTranslator;
        });
    }
}

