/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.Activity;
import java.io.IOException;
import java.util.List;

public final class SwitchCase
implements JsonSerializable<SwitchCase> {
    private String value;
    private List<Activity> activities;

    public String value() {
        return this.value;
    }

    public SwitchCase withValue(String value) {
        this.value = value;
        return this;
    }

    public List<Activity> activities() {
        return this.activities;
    }

    public SwitchCase withActivities(List<Activity> activities) {
        this.activities = activities;
        return this;
    }

    public void validate() {
        if (this.activities() != null) {
            this.activities().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeArrayField("activities", this.activities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SwitchCase fromJson(JsonReader jsonReader) throws IOException {
        return (SwitchCase)jsonReader.readObject(reader -> {
            SwitchCase deserializedSwitchCase = new SwitchCase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedSwitchCase.value = reader.getString();
                    continue;
                }
                if ("activities".equals(fieldName)) {
                    List activities;
                    deserializedSwitchCase.activities = activities = reader.readArray(reader1 -> Activity.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSwitchCase;
        });
    }
}

