/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.SmartsheetLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SmartsheetLinkedService
extends LinkedService {
    private String type = "Smartsheet";
    private SmartsheetLinkedServiceTypeProperties innerTypeProperties = new SmartsheetLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SmartsheetLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    SmartsheetLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public SmartsheetLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public SmartsheetLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public SmartsheetLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public SmartsheetLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public SmartsheetLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public SecretBase apiToken() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().apiToken();
    }

    public SmartsheetLinkedService withApiToken(SecretBase apiToken) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SmartsheetLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withApiToken(apiToken);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public SmartsheetLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SmartsheetLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model SmartsheetLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SmartsheetLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (SmartsheetLinkedService)jsonReader.readObject(reader -> {
            SmartsheetLinkedService deserializedSmartsheetLinkedService = new SmartsheetLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedSmartsheetLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedSmartsheetLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSmartsheetLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSmartsheetLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSmartsheetLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedSmartsheetLinkedService.innerTypeProperties = SmartsheetLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSmartsheetLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSmartsheetLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedSmartsheetLinkedService;
        });
    }
}

