/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.SelfHostedIntegrationRuntimeNodeInner;
import com.azure.resourcemanager.datafactory.fluent.models.SelfHostedIntegrationRuntimeStatusTypeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeAutoUpdate;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeInternalChannelEncryptionMode;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeState;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeStatus;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeType;
import com.azure.resourcemanager.datafactory.models.LinkedIntegrationRuntime;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SelfHostedIntegrationRuntimeStatus
extends IntegrationRuntimeStatus {
    private IntegrationRuntimeType type = IntegrationRuntimeType.SELF_HOSTED;
    private SelfHostedIntegrationRuntimeStatusTypeProperties innerTypeProperties = new SelfHostedIntegrationRuntimeStatusTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SelfHostedIntegrationRuntimeStatus.class);

    @Override
    public IntegrationRuntimeType type() {
        return this.type;
    }

    SelfHostedIntegrationRuntimeStatusTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    public OffsetDateTime createTime() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().createTime();
    }

    public String taskQueueId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().taskQueueId();
    }

    public IntegrationRuntimeInternalChannelEncryptionMode internalChannelEncryption() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().internalChannelEncryption();
    }

    public String version() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().version();
    }

    public List<SelfHostedIntegrationRuntimeNodeInner> nodes() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().nodes();
    }

    public SelfHostedIntegrationRuntimeStatus withNodes(List<SelfHostedIntegrationRuntimeNodeInner> nodes) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SelfHostedIntegrationRuntimeStatusTypeProperties();
        }
        this.innerTypeProperties().withNodes(nodes);
        return this;
    }

    public OffsetDateTime scheduledUpdateDate() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().scheduledUpdateDate();
    }

    public String updateDelayOffset() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().updateDelayOffset();
    }

    public String localTimeZoneOffset() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().localTimeZoneOffset();
    }

    public Map<String, String> capabilities() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().capabilities();
    }

    public List<String> serviceUrls() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().serviceUrls();
    }

    public IntegrationRuntimeAutoUpdate autoUpdate() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().autoUpdate();
    }

    public String versionStatus() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().versionStatus();
    }

    public List<LinkedIntegrationRuntime> links() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().links();
    }

    public SelfHostedIntegrationRuntimeStatus withLinks(List<LinkedIntegrationRuntime> links) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SelfHostedIntegrationRuntimeStatusTypeProperties();
        }
        this.innerTypeProperties().withLinks(links);
        return this;
    }

    public String pushedVersion() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().pushedVersion();
    }

    public String latestVersion() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().latestVersion();
    }

    public OffsetDateTime autoUpdateEta() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().autoUpdateEta();
    }

    public Boolean selfContainedInteractiveAuthoringEnabled() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().selfContainedInteractiveAuthoringEnabled();
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model SelfHostedIntegrationRuntimeStatus"));
        }
        this.innerTypeProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SelfHostedIntegrationRuntimeStatus fromJson(JsonReader jsonReader) throws IOException {
        return (SelfHostedIntegrationRuntimeStatus)jsonReader.readObject(reader -> {
            SelfHostedIntegrationRuntimeStatus deserializedSelfHostedIntegrationRuntimeStatus = new SelfHostedIntegrationRuntimeStatus();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataFactoryName".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeStatus.withDataFactoryName(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeStatus.withState(IntegrationRuntimeState.fromString(reader.getString()));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeStatus.innerTypeProperties = SelfHostedIntegrationRuntimeStatusTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntimeStatus.type = IntegrationRuntimeType.fromString(reader.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSelfHostedIntegrationRuntimeStatus.withAdditionalProperties(additionalProperties);
            return deserializedSelfHostedIntegrationRuntimeStatus;
        });
    }
}

