/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetFolder;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SapBwCubeDataset
extends Dataset {
    private String type = "SapBwCube";
    private static final ClientLogger LOGGER = new ClientLogger(SapBwCubeDataset.class);

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public SapBwCubeDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public SapBwCubeDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    @Override
    public SapBwCubeDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public SapBwCubeDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public SapBwCubeDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public SapBwCubeDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public SapBwCubeDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    @Override
    public void validate() {
        if (this.linkedServiceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedServiceName in model SapBwCubeDataset"));
        }
        this.linkedServiceName().validate();
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.folder() != null) {
            this.folder().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeStringField("description", this.description());
        if (this.structure() != null) {
            jsonWriter.writeUntypedField("structure", this.structure());
        }
        if (this.schema() != null) {
            jsonWriter.writeUntypedField("schema", this.schema());
        }
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder());
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SapBwCubeDataset fromJson(JsonReader jsonReader) throws IOException {
        return (SapBwCubeDataset)jsonReader.readObject(reader -> {
            SapBwCubeDataset deserializedSapBwCubeDataset = new SapBwCubeDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedSapBwCubeDataset.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSapBwCubeDataset.withDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedSapBwCubeDataset.withStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedSapBwCubeDataset.withSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSapBwCubeDataset.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSapBwCubeDataset.withAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedSapBwCubeDataset.withFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSapBwCubeDataset.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSapBwCubeDataset.withAdditionalProperties(additionalProperties);
            return deserializedSapBwCubeDataset;
        });
    }
}

