/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.SalesforceServiceCloudLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SalesforceServiceCloudLinkedService
extends LinkedService {
    private String type = "SalesforceServiceCloud";
    private SalesforceServiceCloudLinkedServiceTypeProperties innerTypeProperties = new SalesforceServiceCloudLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SalesforceServiceCloudLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    SalesforceServiceCloudLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public SalesforceServiceCloudLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public SalesforceServiceCloudLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public SalesforceServiceCloudLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public SalesforceServiceCloudLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public SalesforceServiceCloudLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object environmentUrl() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().environmentUrl();
    }

    public SalesforceServiceCloudLinkedService withEnvironmentUrl(Object environmentUrl) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SalesforceServiceCloudLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEnvironmentUrl(environmentUrl);
        return this;
    }

    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    public SalesforceServiceCloudLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SalesforceServiceCloudLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public SalesforceServiceCloudLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SalesforceServiceCloudLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public SecretBase securityToken() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().securityToken();
    }

    public SalesforceServiceCloudLinkedService withSecurityToken(SecretBase securityToken) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SalesforceServiceCloudLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSecurityToken(securityToken);
        return this;
    }

    public Object apiVersion() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().apiVersion();
    }

    public SalesforceServiceCloudLinkedService withApiVersion(Object apiVersion) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SalesforceServiceCloudLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withApiVersion(apiVersion);
        return this;
    }

    public Object extendedProperties() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().extendedProperties();
    }

    public SalesforceServiceCloudLinkedService withExtendedProperties(Object extendedProperties) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SalesforceServiceCloudLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withExtendedProperties(extendedProperties);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public SalesforceServiceCloudLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SalesforceServiceCloudLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model SalesforceServiceCloudLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SalesforceServiceCloudLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (SalesforceServiceCloudLinkedService)jsonReader.readObject(reader -> {
            SalesforceServiceCloudLinkedService deserializedSalesforceServiceCloudLinkedService = new SalesforceServiceCloudLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedSalesforceServiceCloudLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedSalesforceServiceCloudLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSalesforceServiceCloudLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSalesforceServiceCloudLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSalesforceServiceCloudLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedSalesforceServiceCloudLinkedService.innerTypeProperties = SalesforceServiceCloudLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSalesforceServiceCloudLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSalesforceServiceCloudLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedSalesforceServiceCloudLinkedService;
        });
    }
}

