/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.RunQueryOrder;
import com.azure.resourcemanager.datafactory.models.RunQueryOrderByField;
import java.io.IOException;

public final class RunQueryOrderBy
implements JsonSerializable<RunQueryOrderBy> {
    private RunQueryOrderByField orderBy;
    private RunQueryOrder order;
    private static final ClientLogger LOGGER = new ClientLogger(RunQueryOrderBy.class);

    public RunQueryOrderByField orderBy() {
        return this.orderBy;
    }

    public RunQueryOrderBy withOrderBy(RunQueryOrderByField orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public RunQueryOrder order() {
        return this.order;
    }

    public RunQueryOrderBy withOrder(RunQueryOrder order) {
        this.order = order;
        return this;
    }

    public void validate() {
        if (this.orderBy() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property orderBy in model RunQueryOrderBy"));
        }
        if (this.order() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property order in model RunQueryOrderBy"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("orderBy", this.orderBy == null ? null : this.orderBy.toString());
        jsonWriter.writeStringField("order", this.order == null ? null : this.order.toString());
        return jsonWriter.writeEndObject();
    }

    public static RunQueryOrderBy fromJson(JsonReader jsonReader) throws IOException {
        return (RunQueryOrderBy)jsonReader.readObject(reader -> {
            RunQueryOrderBy deserializedRunQueryOrderBy = new RunQueryOrderBy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("orderBy".equals(fieldName)) {
                    deserializedRunQueryOrderBy.orderBy = RunQueryOrderByField.fromString(reader.getString());
                    continue;
                }
                if ("order".equals(fieldName)) {
                    deserializedRunQueryOrderBy.order = RunQueryOrder.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRunQueryOrderBy;
        });
    }
}

