/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.RestServiceLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.RestServiceAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class RestServiceLinkedService
extends LinkedService {
    private String type = "RestService";
    private RestServiceLinkedServiceTypeProperties innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(RestServiceLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    RestServiceLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public RestServiceLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public RestServiceLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public RestServiceLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public RestServiceLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public RestServiceLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object url() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().url();
    }

    public RestServiceLinkedService withUrl(Object url) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUrl(url);
        return this;
    }

    public Object enableServerCertificateValidation() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().enableServerCertificateValidation();
    }

    public RestServiceLinkedService withEnableServerCertificateValidation(Object enableServerCertificateValidation) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEnableServerCertificateValidation(enableServerCertificateValidation);
        return this;
    }

    public RestServiceAuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    public RestServiceLinkedService withAuthenticationType(RestServiceAuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    public RestServiceLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public RestServiceLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public Object authHeaders() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authHeaders();
    }

    public RestServiceLinkedService withAuthHeaders(Object authHeaders) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthHeaders(authHeaders);
        return this;
    }

    public Object servicePrincipalId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalId();
    }

    public RestServiceLinkedService withServicePrincipalId(Object servicePrincipalId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalId(servicePrincipalId);
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalKey();
    }

    public RestServiceLinkedService withServicePrincipalKey(SecretBase servicePrincipalKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalKey(servicePrincipalKey);
        return this;
    }

    public Object tenant() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tenant();
    }

    public RestServiceLinkedService withTenant(Object tenant) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTenant(tenant);
        return this;
    }

    public Object azureCloudType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().azureCloudType();
    }

    public RestServiceLinkedService withAzureCloudType(Object azureCloudType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAzureCloudType(azureCloudType);
        return this;
    }

    public Object aadResourceId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().aadResourceId();
    }

    public RestServiceLinkedService withAadResourceId(Object aadResourceId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAadResourceId(aadResourceId);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public RestServiceLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    public CredentialReference credential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().credential();
    }

    public RestServiceLinkedService withCredential(CredentialReference credential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCredential(credential);
        return this;
    }

    public Object clientId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientId();
    }

    public RestServiceLinkedService withClientId(Object clientId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withClientId(clientId);
        return this;
    }

    public SecretBase clientSecret() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientSecret();
    }

    public RestServiceLinkedService withClientSecret(SecretBase clientSecret) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withClientSecret(clientSecret);
        return this;
    }

    public Object tokenEndpoint() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tokenEndpoint();
    }

    public RestServiceLinkedService withTokenEndpoint(Object tokenEndpoint) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTokenEndpoint(tokenEndpoint);
        return this;
    }

    public Object resource() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().resource();
    }

    public RestServiceLinkedService withResource(Object resource) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withResource(resource);
        return this;
    }

    public Object scope() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().scope();
    }

    public RestServiceLinkedService withScope(Object scope) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withScope(scope);
        return this;
    }

    public Object servicePrincipalCredentialType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalCredentialType();
    }

    public RestServiceLinkedService withServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalCredentialType(servicePrincipalCredentialType);
        return this;
    }

    public SecretBase servicePrincipalEmbeddedCert() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalEmbeddedCert();
    }

    public RestServiceLinkedService withServicePrincipalEmbeddedCert(SecretBase servicePrincipalEmbeddedCert) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalEmbeddedCert(servicePrincipalEmbeddedCert);
        return this;
    }

    public SecretBase servicePrincipalEmbeddedCertPassword() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalEmbeddedCertPassword();
    }

    public RestServiceLinkedService withServicePrincipalEmbeddedCertPassword(SecretBase servicePrincipalEmbeddedCertPassword) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new RestServiceLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalEmbeddedCertPassword(servicePrincipalEmbeddedCertPassword);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model RestServiceLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static RestServiceLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (RestServiceLinkedService)jsonReader.readObject(reader -> {
            RestServiceLinkedService deserializedRestServiceLinkedService = new RestServiceLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedRestServiceLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedRestServiceLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedRestServiceLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedRestServiceLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedRestServiceLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedRestServiceLinkedService.innerTypeProperties = RestServiceLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRestServiceLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedRestServiceLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedRestServiceLinkedService;
        });
    }
}

