/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.PostgreSqlV2LinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class PostgreSqlV2LinkedService
extends LinkedService {
    private String type = "PostgreSqlV2";
    private PostgreSqlV2LinkedServiceTypeProperties innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(PostgreSqlV2LinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    PostgreSqlV2LinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public PostgreSqlV2LinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public PostgreSqlV2LinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public PostgreSqlV2LinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public PostgreSqlV2LinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public PostgreSqlV2LinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object server() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().server();
    }

    public PostgreSqlV2LinkedService withServer(Object server) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServer(server);
        return this;
    }

    public Object port() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().port();
    }

    public PostgreSqlV2LinkedService withPort(Object port) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPort(port);
        return this;
    }

    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    public PostgreSqlV2LinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    public Object database() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().database();
    }

    public PostgreSqlV2LinkedService withDatabase(Object database) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withDatabase(database);
        return this;
    }

    public Object authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    public PostgreSqlV2LinkedService withAuthenticationType(Object authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    public Object sslMode() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sslMode();
    }

    public PostgreSqlV2LinkedService withSslMode(Object sslMode) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSslMode(sslMode);
        return this;
    }

    public Object schema() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().schema();
    }

    public PostgreSqlV2LinkedService withSchema(Object schema) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSchema(schema);
        return this;
    }

    public Object pooling() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().pooling();
    }

    public PostgreSqlV2LinkedService withPooling(Object pooling) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPooling(pooling);
        return this;
    }

    public Object connectionTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionTimeout();
    }

    public PostgreSqlV2LinkedService withConnectionTimeout(Object connectionTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionTimeout(connectionTimeout);
        return this;
    }

    public Object commandTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().commandTimeout();
    }

    public PostgreSqlV2LinkedService withCommandTimeout(Object commandTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCommandTimeout(commandTimeout);
        return this;
    }

    public Object trustServerCertificate() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().trustServerCertificate();
    }

    public PostgreSqlV2LinkedService withTrustServerCertificate(Object trustServerCertificate) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTrustServerCertificate(trustServerCertificate);
        return this;
    }

    public Object sslCertificate() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sslCertificate();
    }

    public PostgreSqlV2LinkedService withSslCertificate(Object sslCertificate) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSslCertificate(sslCertificate);
        return this;
    }

    public Object sslKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sslKey();
    }

    public PostgreSqlV2LinkedService withSslKey(Object sslKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSslKey(sslKey);
        return this;
    }

    public Object sslPassword() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sslPassword();
    }

    public PostgreSqlV2LinkedService withSslPassword(Object sslPassword) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSslPassword(sslPassword);
        return this;
    }

    public Object readBufferSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().readBufferSize();
    }

    public PostgreSqlV2LinkedService withReadBufferSize(Object readBufferSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withReadBufferSize(readBufferSize);
        return this;
    }

    public Object logParameters() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().logParameters();
    }

    public PostgreSqlV2LinkedService withLogParameters(Object logParameters) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withLogParameters(logParameters);
        return this;
    }

    public Object timezone() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().timezone();
    }

    public PostgreSqlV2LinkedService withTimezone(Object timezone) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTimezone(timezone);
        return this;
    }

    public Object encoding() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encoding();
    }

    public PostgreSqlV2LinkedService withEncoding(Object encoding) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncoding(encoding);
        return this;
    }

    public AzureKeyVaultSecretReference password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public PostgreSqlV2LinkedService withPassword(AzureKeyVaultSecretReference password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public PostgreSqlV2LinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new PostgreSqlV2LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model PostgreSqlV2LinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static PostgreSqlV2LinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (PostgreSqlV2LinkedService)jsonReader.readObject(reader -> {
            PostgreSqlV2LinkedService deserializedPostgreSqlV2LinkedService = new PostgreSqlV2LinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedPostgreSqlV2LinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedPostgreSqlV2LinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedService.innerTypeProperties = PostgreSqlV2LinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPostgreSqlV2LinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedPostgreSqlV2LinkedService.withAdditionalProperties(additionalProperties);
            return deserializedPostgreSqlV2LinkedService;
        });
    }
}

