/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.OracleLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.OracleAuthenticationType;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class OracleLinkedService
extends LinkedService {
    private String type = "Oracle";
    private OracleLinkedServiceTypeProperties innerTypeProperties = new OracleLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(OracleLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    OracleLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public OracleLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public OracleLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public OracleLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public OracleLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public OracleLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object connectionString() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionString();
    }

    public OracleLinkedService withConnectionString(Object connectionString) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new OracleLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionString(connectionString);
        return this;
    }

    public Object server() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().server();
    }

    public OracleLinkedService withServer(Object server) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new OracleLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServer(server);
        return this;
    }

    public OracleAuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    public OracleLinkedService withAuthenticationType(OracleAuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new OracleLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    public OracleLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new OracleLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    public AzureKeyVaultSecretReference password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public OracleLinkedService withPassword(AzureKeyVaultSecretReference password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new OracleLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public Object encryptionClient() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptionClient();
    }

    public OracleLinkedService withEncryptionClient(Object encryptionClient) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new OracleLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptionClient(encryptionClient);
        return this;
    }

    public Object encryptionTypesClient() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptionTypesClient();
    }

    public OracleLinkedService withEncryptionTypesClient(Object encryptionTypesClient) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new OracleLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptionTypesClient(encryptionTypesClient);
        return this;
    }

    public Object cryptoChecksumClient() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().cryptoChecksumClient();
    }

    public OracleLinkedService withCryptoChecksumClient(Object cryptoChecksumClient) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new OracleLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCryptoChecksumClient(cryptoChecksumClient);
        return this;
    }

    public Object cryptoChecksumTypesClient() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().cryptoChecksumTypesClient();
    }

    public OracleLinkedService withCryptoChecksumTypesClient(Object cryptoChecksumTypesClient) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new OracleLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCryptoChecksumTypesClient(cryptoChecksumTypesClient);
        return this;
    }

    public Object initialLobFetchSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().initialLobFetchSize();
    }

    public OracleLinkedService withInitialLobFetchSize(Object initialLobFetchSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new OracleLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withInitialLobFetchSize(initialLobFetchSize);
        return this;
    }

    public Object fetchSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().fetchSize();
    }

    public OracleLinkedService withFetchSize(Object fetchSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new OracleLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withFetchSize(fetchSize);
        return this;
    }

    public Object statementCacheSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().statementCacheSize();
    }

    public OracleLinkedService withStatementCacheSize(Object statementCacheSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new OracleLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withStatementCacheSize(statementCacheSize);
        return this;
    }

    public Object initializationString() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().initializationString();
    }

    public OracleLinkedService withInitializationString(Object initializationString) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new OracleLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withInitializationString(initializationString);
        return this;
    }

    public Object enableBulkLoad() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().enableBulkLoad();
    }

    public OracleLinkedService withEnableBulkLoad(Object enableBulkLoad) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new OracleLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEnableBulkLoad(enableBulkLoad);
        return this;
    }

    public Object supportV1DataTypes() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().supportV1DataTypes();
    }

    public OracleLinkedService withSupportV1DataTypes(Object supportV1DataTypes) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new OracleLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSupportV1DataTypes(supportV1DataTypes);
        return this;
    }

    public Object fetchTswtzAsTimestamp() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().fetchTswtzAsTimestamp();
    }

    public OracleLinkedService withFetchTswtzAsTimestamp(Object fetchTswtzAsTimestamp) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new OracleLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withFetchTswtzAsTimestamp(fetchTswtzAsTimestamp);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public OracleLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new OracleLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model OracleLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static OracleLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (OracleLinkedService)jsonReader.readObject(reader -> {
            OracleLinkedService deserializedOracleLinkedService = new OracleLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedOracleLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedOracleLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedOracleLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedOracleLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedOracleLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedOracleLinkedService.innerTypeProperties = OracleLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedOracleLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedOracleLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedOracleLinkedService;
        });
    }
}

