/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.MapperTableProperties;
import com.azure.resourcemanager.datafactory.models.MapperDslConnectorProperties;
import com.azure.resourcemanager.datafactory.models.MapperTableSchema;
import java.io.IOException;
import java.util.List;

public final class MapperTable
implements JsonSerializable<MapperTable> {
    private String name;
    private MapperTableProperties innerProperties;

    public String name() {
        return this.name;
    }

    public MapperTable withName(String name) {
        this.name = name;
        return this;
    }

    private MapperTableProperties innerProperties() {
        return this.innerProperties;
    }

    public List<MapperTableSchema> schema() {
        return this.innerProperties() == null ? null : this.innerProperties().schema();
    }

    public MapperTable withSchema(List<MapperTableSchema> schema) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MapperTableProperties();
        }
        this.innerProperties().withSchema(schema);
        return this;
    }

    public List<MapperDslConnectorProperties> dslConnectorProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().dslConnectorProperties();
    }

    public MapperTable withDslConnectorProperties(List<MapperDslConnectorProperties> dslConnectorProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MapperTableProperties();
        }
        this.innerProperties().withDslConnectorProperties(dslConnectorProperties);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static MapperTable fromJson(JsonReader jsonReader) throws IOException {
        return (MapperTable)jsonReader.readObject(reader -> {
            MapperTable deserializedMapperTable = new MapperTable();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedMapperTable.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMapperTable.innerProperties = MapperTableProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMapperTable;
        });
    }
}

