/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ManagedVirtualNetworkReferenceType;
import java.io.IOException;

public final class ManagedVirtualNetworkReference
implements JsonSerializable<ManagedVirtualNetworkReference> {
    private ManagedVirtualNetworkReferenceType type;
    private String referenceName;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedVirtualNetworkReference.class);

    public ManagedVirtualNetworkReferenceType type() {
        return this.type;
    }

    public ManagedVirtualNetworkReference withType(ManagedVirtualNetworkReferenceType type) {
        this.type = type;
        return this;
    }

    public String referenceName() {
        return this.referenceName;
    }

    public ManagedVirtualNetworkReference withReferenceName(String referenceName) {
        this.referenceName = referenceName;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model ManagedVirtualNetworkReference"));
        }
        if (this.referenceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property referenceName in model ManagedVirtualNetworkReference"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("referenceName", this.referenceName);
        return jsonWriter.writeEndObject();
    }

    public static ManagedVirtualNetworkReference fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedVirtualNetworkReference)jsonReader.readObject(reader -> {
            ManagedVirtualNetworkReference deserializedManagedVirtualNetworkReference = new ManagedVirtualNetworkReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedManagedVirtualNetworkReference.type = ManagedVirtualNetworkReferenceType.fromString(reader.getString());
                    continue;
                }
                if ("referenceName".equals(fieldName)) {
                    deserializedManagedVirtualNetworkReference.referenceName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedVirtualNetworkReference;
        });
    }
}

