/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ManagedIntegrationRuntimeOperationResult
implements JsonSerializable<ManagedIntegrationRuntimeOperationResult> {
    private String type;
    private OffsetDateTime startTime;
    private String result;
    private String errorCode;
    private List<String> parameters;
    private String activityId;
    private Map<String, Object> additionalProperties;

    public String type() {
        return this.type;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public String result() {
        return this.result;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public List<String> parameters() {
        return this.parameters;
    }

    public String activityId() {
        return this.activityId;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public ManagedIntegrationRuntimeOperationResult withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ManagedIntegrationRuntimeOperationResult fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedIntegrationRuntimeOperationResult)jsonReader.readObject(reader -> {
            ManagedIntegrationRuntimeOperationResult deserializedManagedIntegrationRuntimeOperationResult = new ManagedIntegrationRuntimeOperationResult();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedManagedIntegrationRuntimeOperationResult.type = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedManagedIntegrationRuntimeOperationResult.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("result".equals(fieldName)) {
                    deserializedManagedIntegrationRuntimeOperationResult.result = reader.getString();
                    continue;
                }
                if ("errorCode".equals(fieldName)) {
                    deserializedManagedIntegrationRuntimeOperationResult.errorCode = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    List parameters;
                    deserializedManagedIntegrationRuntimeOperationResult.parameters = parameters = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("activityId".equals(fieldName)) {
                    deserializedManagedIntegrationRuntimeOperationResult.activityId = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedManagedIntegrationRuntimeOperationResult.additionalProperties = additionalProperties;
            return deserializedManagedIntegrationRuntimeOperationResult;
        });
    }
}

