/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class LogStorageSettings
implements JsonSerializable<LogStorageSettings> {
    private LinkedServiceReference linkedServiceName;
    private Object path;
    private Object logLevel;
    private Object enableReliableLogging;
    private Map<String, Object> additionalProperties;
    private static final ClientLogger LOGGER = new ClientLogger(LogStorageSettings.class);

    public LinkedServiceReference linkedServiceName() {
        return this.linkedServiceName;
    }

    public LogStorageSettings withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        this.linkedServiceName = linkedServiceName;
        return this;
    }

    public Object path() {
        return this.path;
    }

    public LogStorageSettings withPath(Object path) {
        this.path = path;
        return this;
    }

    public Object logLevel() {
        return this.logLevel;
    }

    public LogStorageSettings withLogLevel(Object logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public Object enableReliableLogging() {
        return this.enableReliableLogging;
    }

    public LogStorageSettings withEnableReliableLogging(Object enableReliableLogging) {
        this.enableReliableLogging = enableReliableLogging;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public LogStorageSettings withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.linkedServiceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedServiceName in model LogStorageSettings"));
        }
        this.linkedServiceName().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName);
        if (this.path != null) {
            jsonWriter.writeUntypedField("path", this.path);
        }
        if (this.logLevel != null) {
            jsonWriter.writeUntypedField("logLevel", this.logLevel);
        }
        if (this.enableReliableLogging != null) {
            jsonWriter.writeUntypedField("enableReliableLogging", this.enableReliableLogging);
        }
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static LogStorageSettings fromJson(JsonReader jsonReader) throws IOException {
        return (LogStorageSettings)jsonReader.readObject(reader -> {
            LogStorageSettings deserializedLogStorageSettings = new LogStorageSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedLogStorageSettings.linkedServiceName = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("path".equals(fieldName)) {
                    deserializedLogStorageSettings.path = reader.readUntyped();
                    continue;
                }
                if ("logLevel".equals(fieldName)) {
                    deserializedLogStorageSettings.logLevel = reader.readUntyped();
                    continue;
                }
                if ("enableReliableLogging".equals(fieldName)) {
                    deserializedLogStorageSettings.enableReliableLogging = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedLogStorageSettings.additionalProperties = additionalProperties;
            return deserializedLogStorageSettings;
        });
    }
}

