/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class LinkedIntegrationRuntimeRequest
implements JsonSerializable<LinkedIntegrationRuntimeRequest> {
    private String linkedFactoryName;
    private static final ClientLogger LOGGER = new ClientLogger(LinkedIntegrationRuntimeRequest.class);

    public String linkedFactoryName() {
        return this.linkedFactoryName;
    }

    public LinkedIntegrationRuntimeRequest withLinkedFactoryName(String linkedFactoryName) {
        this.linkedFactoryName = linkedFactoryName;
        return this;
    }

    public void validate() {
        if (this.linkedFactoryName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedFactoryName in model LinkedIntegrationRuntimeRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("factoryName", this.linkedFactoryName);
        return jsonWriter.writeEndObject();
    }

    public static LinkedIntegrationRuntimeRequest fromJson(JsonReader jsonReader) throws IOException {
        return (LinkedIntegrationRuntimeRequest)jsonReader.readObject(reader -> {
            LinkedIntegrationRuntimeRequest deserializedLinkedIntegrationRuntimeRequest = new LinkedIntegrationRuntimeRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("factoryName".equals(fieldName)) {
                    deserializedLinkedIntegrationRuntimeRequest.linkedFactoryName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinkedIntegrationRuntimeRequest;
        });
    }
}

