/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class GoogleCloudStorageLocation
extends DatasetLocation {
    private String type = "GoogleCloudStorageLocation";
    private Object bucketName;
    private Object version;

    @Override
    public String type() {
        return this.type;
    }

    public Object bucketName() {
        return this.bucketName;
    }

    public GoogleCloudStorageLocation withBucketName(Object bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    public Object version() {
        return this.version;
    }

    public GoogleCloudStorageLocation withVersion(Object version) {
        this.version = version;
        return this;
    }

    @Override
    public GoogleCloudStorageLocation withFolderPath(Object folderPath) {
        super.withFolderPath(folderPath);
        return this;
    }

    @Override
    public GoogleCloudStorageLocation withFileName(Object fileName) {
        super.withFileName(fileName);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.folderPath() != null) {
            jsonWriter.writeUntypedField("folderPath", this.folderPath());
        }
        if (this.fileName() != null) {
            jsonWriter.writeUntypedField("fileName", this.fileName());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.bucketName != null) {
            jsonWriter.writeUntypedField("bucketName", this.bucketName);
        }
        if (this.version != null) {
            jsonWriter.writeUntypedField("version", this.version);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static GoogleCloudStorageLocation fromJson(JsonReader jsonReader) throws IOException {
        return (GoogleCloudStorageLocation)jsonReader.readObject(reader -> {
            GoogleCloudStorageLocation deserializedGoogleCloudStorageLocation = new GoogleCloudStorageLocation();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("folderPath".equals(fieldName)) {
                    deserializedGoogleCloudStorageLocation.withFolderPath(reader.readUntyped());
                    continue;
                }
                if ("fileName".equals(fieldName)) {
                    deserializedGoogleCloudStorageLocation.withFileName(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGoogleCloudStorageLocation.type = reader.getString();
                    continue;
                }
                if ("bucketName".equals(fieldName)) {
                    deserializedGoogleCloudStorageLocation.bucketName = reader.readUntyped();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedGoogleCloudStorageLocation.version = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedGoogleCloudStorageLocation.withAdditionalProperties(additionalProperties);
            return deserializedGoogleCloudStorageLocation;
        });
    }
}

