/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.GoogleAdWordsLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.GoogleAdWordsAuthenticationType;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class GoogleAdWordsLinkedService
extends LinkedService {
    private String type = "GoogleAdWords";
    private GoogleAdWordsLinkedServiceTypeProperties innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(GoogleAdWordsLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    GoogleAdWordsLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public GoogleAdWordsLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public GoogleAdWordsLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public GoogleAdWordsLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public GoogleAdWordsLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public GoogleAdWordsLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object connectionProperties() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionProperties();
    }

    public GoogleAdWordsLinkedService withConnectionProperties(Object connectionProperties) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionProperties(connectionProperties);
        return this;
    }

    public Object clientCustomerId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientCustomerId();
    }

    public GoogleAdWordsLinkedService withClientCustomerId(Object clientCustomerId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withClientCustomerId(clientCustomerId);
        return this;
    }

    public SecretBase developerToken() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().developerToken();
    }

    public GoogleAdWordsLinkedService withDeveloperToken(SecretBase developerToken) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withDeveloperToken(developerToken);
        return this;
    }

    public GoogleAdWordsAuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    public GoogleAdWordsLinkedService withAuthenticationType(GoogleAdWordsAuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    public SecretBase refreshToken() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().refreshToken();
    }

    public GoogleAdWordsLinkedService withRefreshToken(SecretBase refreshToken) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withRefreshToken(refreshToken);
        return this;
    }

    public Object clientId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientId();
    }

    public GoogleAdWordsLinkedService withClientId(Object clientId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withClientId(clientId);
        return this;
    }

    public SecretBase clientSecret() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().clientSecret();
    }

    public GoogleAdWordsLinkedService withClientSecret(SecretBase clientSecret) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withClientSecret(clientSecret);
        return this;
    }

    public Object email() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().email();
    }

    public GoogleAdWordsLinkedService withEmail(Object email) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEmail(email);
        return this;
    }

    public Object keyFilePath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().keyFilePath();
    }

    public GoogleAdWordsLinkedService withKeyFilePath(Object keyFilePath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withKeyFilePath(keyFilePath);
        return this;
    }

    public Object trustedCertPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().trustedCertPath();
    }

    public GoogleAdWordsLinkedService withTrustedCertPath(Object trustedCertPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTrustedCertPath(trustedCertPath);
        return this;
    }

    public Object useSystemTrustStore() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().useSystemTrustStore();
    }

    public GoogleAdWordsLinkedService withUseSystemTrustStore(Object useSystemTrustStore) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUseSystemTrustStore(useSystemTrustStore);
        return this;
    }

    public SecretBase privateKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().privateKey();
    }

    public GoogleAdWordsLinkedService withPrivateKey(SecretBase privateKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPrivateKey(privateKey);
        return this;
    }

    public Object loginCustomerId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().loginCustomerId();
    }

    public GoogleAdWordsLinkedService withLoginCustomerId(Object loginCustomerId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withLoginCustomerId(loginCustomerId);
        return this;
    }

    public Object googleAdsApiVersion() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().googleAdsApiVersion();
    }

    public GoogleAdWordsLinkedService withGoogleAdsApiVersion(Object googleAdsApiVersion) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withGoogleAdsApiVersion(googleAdsApiVersion);
        return this;
    }

    public Object supportLegacyDataTypes() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().supportLegacyDataTypes();
    }

    public GoogleAdWordsLinkedService withSupportLegacyDataTypes(Object supportLegacyDataTypes) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSupportLegacyDataTypes(supportLegacyDataTypes);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public GoogleAdWordsLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GoogleAdWordsLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model GoogleAdWordsLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static GoogleAdWordsLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (GoogleAdWordsLinkedService)jsonReader.readObject(reader -> {
            GoogleAdWordsLinkedService deserializedGoogleAdWordsLinkedService = new GoogleAdWordsLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedGoogleAdWordsLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedGoogleAdWordsLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedService.innerTypeProperties = GoogleAdWordsLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGoogleAdWordsLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedGoogleAdWordsLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedGoogleAdWordsLinkedService;
        });
    }
}

